<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemporalDatumBaseType StructType
 * @subpackage Structs
 */
class TemporalDatumBaseType extends AbstractStructBase
{
    /**
     * The metaDataProperty
     * @var \StructType\MetaDataPropertyType
     */
    public $metaDataProperty;
    /**
     * The description
     * @var \StructType\StringOrRefType
     */
    public $description;
    /**
     * The descriptionReference
     * @var \StructType\ReferenceType
     */
    public $descriptionReference;
    /**
     * The identifier
     * @var \StructType\CodeWithAuthorityType
     */
    public $identifier;
    /**
     * The name
     * @var \StructType\CodeType
     */
    public $name;
    /**
     * The remarks
     * @var string
     */
    public $remarks;
    /**
     * The domainOfValidity
     * @var \StructType\DomainOfValidity
     */
    public $domainOfValidity;
    /**
     * The scope
     * @var string
     */
    public $scope;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * Constructor method for TemporalDatumBaseType
     * @uses TemporalDatumBaseType::setMetaDataProperty()
     * @uses TemporalDatumBaseType::setDescription()
     * @uses TemporalDatumBaseType::setDescriptionReference()
     * @uses TemporalDatumBaseType::setIdentifier()
     * @uses TemporalDatumBaseType::setName()
     * @uses TemporalDatumBaseType::setRemarks()
     * @uses TemporalDatumBaseType::setDomainOfValidity()
     * @uses TemporalDatumBaseType::setScope()
     * @uses TemporalDatumBaseType::setId()
     * @param \StructType\MetaDataPropertyType $metaDataProperty
     * @param \StructType\StringOrRefType $description
     * @param \StructType\ReferenceType $descriptionReference
     * @param \StructType\CodeWithAuthorityType $identifier
     * @param \StructType\CodeType $name
     * @param string $remarks
     * @param \StructType\DomainOfValidity $domainOfValidity
     * @param string $scope
     * @param string $id
     */
    public function __construct(\StructType\MetaDataPropertyType $metaDataProperty = null, \StructType\StringOrRefType $description = null, \StructType\ReferenceType $descriptionReference = null, \StructType\CodeWithAuthorityType $identifier = null, \StructType\CodeType $name = null, $remarks = null, \StructType\DomainOfValidity $domainOfValidity = null, $scope = null, $id = null)
    {
        $this
            ->setMetaDataProperty($metaDataProperty)
            ->setDescription($description)
            ->setDescriptionReference($descriptionReference)
            ->setIdentifier($identifier)
            ->setName($name)
            ->setRemarks($remarks)
            ->setDomainOfValidity($domainOfValidity)
            ->setScope($scope)
            ->setId($id);
    }
    /**
     * Get metaDataProperty value
     * @return \StructType\MetaDataPropertyType|null
     */
    public function getMetaDataProperty()
    {
        return $this->metaDataProperty;
    }
    /**
     * Set metaDataProperty value
     * @param \StructType\MetaDataPropertyType $metaDataProperty
     * @return \StructType\TemporalDatumBaseType
     */
    public function setMetaDataProperty(\StructType\MetaDataPropertyType $metaDataProperty = null)
    {
        $this->metaDataProperty = $metaDataProperty;
        return $this;
    }
    /**
     * Get description value
     * @return \StructType\StringOrRefType|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param \StructType\StringOrRefType $description
     * @return \StructType\TemporalDatumBaseType
     */
    public function setDescription(\StructType\StringOrRefType $description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get descriptionReference value
     * @return \StructType\ReferenceType|null
     */
    public function getDescriptionReference()
    {
        return $this->descriptionReference;
    }
    /**
     * Set descriptionReference value
     * @param \StructType\ReferenceType $descriptionReference
     * @return \StructType\TemporalDatumBaseType
     */
    public function setDescriptionReference(\StructType\ReferenceType $descriptionReference = null)
    {
        $this->descriptionReference = $descriptionReference;
        return $this;
    }
    /**
     * Get identifier value
     * @return \StructType\CodeWithAuthorityType|null
     */
    public function getIdentifier()
    {
        return $this->identifier;
    }
    /**
     * Set identifier value
     * @param \StructType\CodeWithAuthorityType $identifier
     * @return \StructType\TemporalDatumBaseType
     */
    public function setIdentifier(\StructType\CodeWithAuthorityType $identifier = null)
    {
        $this->identifier = $identifier;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\CodeType|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param \StructType\CodeType $name
     * @return \StructType\TemporalDatumBaseType
     */
    public function setName(\StructType\CodeType $name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->remarks;
    }
    /**
     * Set remarks value
     * @param string $remarks
     * @return \StructType\TemporalDatumBaseType
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        $this->remarks = $remarks;
        return $this;
    }
    /**
     * Get domainOfValidity value
     * @return \StructType\DomainOfValidity|null
     */
    public function getDomainOfValidity()
    {
        return $this->domainOfValidity;
    }
    /**
     * Set domainOfValidity value
     * @param \StructType\DomainOfValidity $domainOfValidity
     * @return \StructType\TemporalDatumBaseType
     */
    public function setDomainOfValidity(\StructType\DomainOfValidity $domainOfValidity = null)
    {
        $this->domainOfValidity = $domainOfValidity;
        return $this;
    }
    /**
     * Get scope value
     * @return string|null
     */
    public function getScope()
    {
        return $this->scope;
    }
    /**
     * Set scope value
     * @param string $scope
     * @return \StructType\TemporalDatumBaseType
     */
    public function setScope($scope = null)
    {
        // validation for constraint: string
        if (!is_null($scope) && !is_string($scope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scope, true), gettype($scope)), __LINE__);
        }
        $this->scope = $scope;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\TemporalDatumBaseType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
}
