<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurfaceArrayPropertyType StructType
 * @subpackage Structs
 */
class SurfaceArrayPropertyType extends AbstractStructBase
{
    /**
     * The AbstractSurface
     * @var \StructType\AbstractSurfaceType
     */
    public $AbstractSurface;
    /**
     * The owns
     * @var bool
     */
    public $owns;
    /**
     * Constructor method for SurfaceArrayPropertyType
     * @uses SurfaceArrayPropertyType::setAbstractSurface()
     * @uses SurfaceArrayPropertyType::setOwns()
     * @param \StructType\AbstractSurfaceType $abstractSurface
     * @param bool $owns
     */
    public function __construct(\StructType\AbstractSurfaceType $abstractSurface = null, $owns = null)
    {
        $this
            ->setAbstractSurface($abstractSurface)
            ->setOwns($owns);
    }
    /**
     * Get AbstractSurface value
     * @return \StructType\AbstractSurfaceType|null
     */
    public function getAbstractSurface()
    {
        return $this->AbstractSurface;
    }
    /**
     * Set AbstractSurface value
     * @param \StructType\AbstractSurfaceType $abstractSurface
     * @return \StructType\SurfaceArrayPropertyType
     */
    public function setAbstractSurface(\StructType\AbstractSurfaceType $abstractSurface = null)
    {
        $this->AbstractSurface = $abstractSurface;
        return $this;
    }
    /**
     * Get owns value
     * @return bool|null
     */
    public function getOwns()
    {
        return $this->owns;
    }
    /**
     * Set owns value
     * @param bool $owns
     * @return \StructType\SurfaceArrayPropertyType
     */
    public function setOwns($owns = null)
    {
        // validation for constraint: boolean
        if (!is_null($owns) && !is_bool($owns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($owns, true), gettype($owns)), __LINE__);
        }
        $this->owns = $owns;
        return $this;
    }
}
