<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuchprofilSpezialisierung StructType
 * Meta information extracted from the WSDL
 * - documentation: Suchprofil für Spezialisierungen.
 * @subpackage Structs
 */
class SuchprofilSpezialisierung extends Suchprofil
{
    /**
     * The leistungID
     * Meta information extracted from the WSDL
     * - documentation: ID der Leistung, für welche Spezialisierungen vorliegen.
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $leistungID;
    /**
     * The gebietID
     * Meta information extracted from the WSDL
     * - documentation: ID des oder der Gebiete, für welche die Spezialisierungen gelten sollen. Über 'sucheAbwaerts' kann gesteuert werden, ob auch darunterliegende Gebiete durchsucht werden sollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $gebietID;
    /**
     * The sucheAbwaerts
     * Meta information extracted from the WSDL
     * - documentation: Ist das Kennzeichen gesetzt, werden für die unter 'gebietID' angegebenen Gebiete auch alle darunterliegenden Gebierte betrachtet.
     * - default: false
     * - minOccurs: 0
     * @var bool
     */
    public $sucheAbwaerts;
    /**
     * Constructor method for SuchprofilSpezialisierung
     * @uses SuchprofilSpezialisierung::setLeistungID()
     * @uses SuchprofilSpezialisierung::setGebietID()
     * @uses SuchprofilSpezialisierung::setSucheAbwaerts()
     * @param \StructType\Identifikator $leistungID
     * @param \StructType\Identifikator[] $gebietID
     * @param bool $sucheAbwaerts
     */
    public function __construct(\StructType\Identifikator $leistungID = null, array $gebietID = array(), $sucheAbwaerts = false)
    {
        $this
            ->setLeistungID($leistungID)
            ->setGebietID($gebietID)
            ->setSucheAbwaerts($sucheAbwaerts);
    }
    /**
     * Get leistungID value
     * @return \StructType\Identifikator|null
     */
    public function getLeistungID()
    {
        return $this->leistungID;
    }
    /**
     * Set leistungID value
     * @param \StructType\Identifikator $leistungID
     * @return \StructType\SuchprofilSpezialisierung
     */
    public function setLeistungID(\StructType\Identifikator $leistungID = null)
    {
        $this->leistungID = $leistungID;
        return $this;
    }
    /**
     * Get gebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getGebietID()
    {
        return $this->gebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGebietIDForArrayConstraintsFromSetGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilSpezialisierungGebietIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilSpezialisierungGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilSpezialisierungGebietIDItem) ? get_class($suchprofilSpezialisierungGebietIDItem) : sprintf('%s(%s)', gettype($suchprofilSpezialisierungGebietIDItem), var_export($suchprofilSpezialisierungGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $gebietID
     * @return \StructType\SuchprofilSpezialisierung
     */
    public function setGebietID(array $gebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($gebietIDArrayErrorMessage = self::validateGebietIDForArrayConstraintsFromSetGebietID($gebietID))) {
            throw new \InvalidArgumentException($gebietIDArrayErrorMessage, __LINE__);
        }
        $this->gebietID = $gebietID;
        return $this;
    }
    /**
     * Add item to gebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilSpezialisierung
     */
    public function addToGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The gebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gebietID[] = $item;
        return $this;
    }
    /**
     * Get sucheAbwaerts value
     * @return bool|null
     */
    public function getSucheAbwaerts()
    {
        return $this->sucheAbwaerts;
    }
    /**
     * Set sucheAbwaerts value
     * @param bool $sucheAbwaerts
     * @return \StructType\SuchprofilSpezialisierung
     */
    public function setSucheAbwaerts($sucheAbwaerts = false)
    {
        // validation for constraint: boolean
        if (!is_null($sucheAbwaerts) && !is_bool($sucheAbwaerts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sucheAbwaerts, true), gettype($sucheAbwaerts)), __LINE__);
        }
        $this->sucheAbwaerts = $sucheAbwaerts;
        return $this;
    }
}
