<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuchprofilOnlinedienst StructType
 * Meta information extracted from the WSDL
 * - documentation: Suchprofil für Onlinedienste.
 * @subpackage Structs
 */
class SuchprofilOnlinedienst extends Suchprofil
{
    /**
     * The zustaendigkeitLeistungID
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Leistungen, für welche der Onlinedienst zuständig sein soll. In Kombination mit zustaendigkeitGebietID. Hierdurch kann eine Suche nach zuständigen Onlinediensten realisiert werden. Die Angabe von zustaendigkeitGebietID
     * und zustaendigkeitLeistungID wird logisch UND verknüpft, d.h. die OE muss für alle Leistungen für alle Gebiete zuständig sein.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $zustaendigkeitLeistungID;
    /**
     * The zustaendigkeitGebietID
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Gebieten, für welche der Onlinedienst zuständig sein soll. In Kombination mit zustaendigkeitLeistungID. Achtung: Es muss hier unbedingt die geografische Zuständigkeit beachtet werden. Beispiel: Wird hier das Gebiet
     * "Sachsen-Anhalt" angegeben, dürfen auch nur OEs, welche für ganz Sachsen-Anhalt zuständig sind, ausgegeben werden. Zum Beispiel Ministerien, Landesverwaltungsamt etc. Wird eine konkrete Gemeinde angegeben, muss das System den Gebietsbaum bis zur
     * Wurzel durchsuchen, da auch Zuständigkeiten für den Landkreis, Regierungsbezirk, Bundesland oder Deutschland zum Tragen kommen können.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $zustaendigkeitGebietID;
    /**
     * The durchfuehrungSprache
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Sprachen, in denen die Onlinedienste durchführbar sein sollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Sprache[]
     */
    public $durchfuehrungSprache;
    /**
     * The kennzeichenErweiterteAusgabe
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob im Ergebnis Onlinedienst oder OnlinedienstErweitert zurückgeben werden soll. Letztere enthält alle Zuständigkeiten.
     * - default: false
     * @var bool
     */
    public $kennzeichenErweiterteAusgabe;
    /**
     * The kennzeichenNurBasisinformation
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob nur Basisinformationen zurückgegeben werden soll. In NachrichtenAntworten wird dann anstatt des eigentlichen Objekts das BasisinformationObjekt zurückgegeben.
     * - default: false
     * @var bool
     */
    public $kennzeichenNurBasisinformation;
    /**
     * Constructor method for SuchprofilOnlinedienst
     * @uses SuchprofilOnlinedienst::setZustaendigkeitLeistungID()
     * @uses SuchprofilOnlinedienst::setZustaendigkeitGebietID()
     * @uses SuchprofilOnlinedienst::setDurchfuehrungSprache()
     * @uses SuchprofilOnlinedienst::setKennzeichenErweiterteAusgabe()
     * @uses SuchprofilOnlinedienst::setKennzeichenNurBasisinformation()
     * @param \StructType\Identifikator[] $zustaendigkeitLeistungID
     * @param \StructType\Identifikator[] $zustaendigkeitGebietID
     * @param \StructType\Sprache[] $durchfuehrungSprache
     * @param bool $kennzeichenErweiterteAusgabe
     * @param bool $kennzeichenNurBasisinformation
     */
    public function __construct(array $zustaendigkeitLeistungID = array(), array $zustaendigkeitGebietID = array(), array $durchfuehrungSprache = array(), $kennzeichenErweiterteAusgabe = false, $kennzeichenNurBasisinformation = false)
    {
        $this
            ->setZustaendigkeitLeistungID($zustaendigkeitLeistungID)
            ->setZustaendigkeitGebietID($zustaendigkeitGebietID)
            ->setDurchfuehrungSprache($durchfuehrungSprache)
            ->setKennzeichenErweiterteAusgabe($kennzeichenErweiterteAusgabe)
            ->setKennzeichenNurBasisinformation($kennzeichenNurBasisinformation);
    }
    /**
     * Get zustaendigkeitLeistungID value
     * @return \StructType\Identifikator[]|null
     */
    public function getZustaendigkeitLeistungID()
    {
        return $this->zustaendigkeitLeistungID;
    }
    /**
     * This method is responsible for validating the values passed to the setZustaendigkeitLeistungID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZustaendigkeitLeistungID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZustaendigkeitLeistungIDForArrayConstraintsFromSetZustaendigkeitLeistungID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilOnlinedienstZustaendigkeitLeistungIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilOnlinedienstZustaendigkeitLeistungIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilOnlinedienstZustaendigkeitLeistungIDItem) ? get_class($suchprofilOnlinedienstZustaendigkeitLeistungIDItem) : sprintf('%s(%s)', gettype($suchprofilOnlinedienstZustaendigkeitLeistungIDItem), var_export($suchprofilOnlinedienstZustaendigkeitLeistungIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zustaendigkeitLeistungID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zustaendigkeitLeistungID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $zustaendigkeitLeistungID
     * @return \StructType\SuchprofilOnlinedienst
     */
    public function setZustaendigkeitLeistungID(array $zustaendigkeitLeistungID = array())
    {
        // validation for constraint: array
        if ('' !== ($zustaendigkeitLeistungIDArrayErrorMessage = self::validateZustaendigkeitLeistungIDForArrayConstraintsFromSetZustaendigkeitLeistungID($zustaendigkeitLeistungID))) {
            throw new \InvalidArgumentException($zustaendigkeitLeistungIDArrayErrorMessage, __LINE__);
        }
        $this->zustaendigkeitLeistungID = $zustaendigkeitLeistungID;
        return $this;
    }
    /**
     * Add item to zustaendigkeitLeistungID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilOnlinedienst
     */
    public function addToZustaendigkeitLeistungID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The zustaendigkeitLeistungID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zustaendigkeitLeistungID[] = $item;
        return $this;
    }
    /**
     * Get zustaendigkeitGebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getZustaendigkeitGebietID()
    {
        return $this->zustaendigkeitGebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setZustaendigkeitGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZustaendigkeitGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZustaendigkeitGebietIDForArrayConstraintsFromSetZustaendigkeitGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilOnlinedienstZustaendigkeitGebietIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilOnlinedienstZustaendigkeitGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilOnlinedienstZustaendigkeitGebietIDItem) ? get_class($suchprofilOnlinedienstZustaendigkeitGebietIDItem) : sprintf('%s(%s)', gettype($suchprofilOnlinedienstZustaendigkeitGebietIDItem), var_export($suchprofilOnlinedienstZustaendigkeitGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zustaendigkeitGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zustaendigkeitGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $zustaendigkeitGebietID
     * @return \StructType\SuchprofilOnlinedienst
     */
    public function setZustaendigkeitGebietID(array $zustaendigkeitGebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($zustaendigkeitGebietIDArrayErrorMessage = self::validateZustaendigkeitGebietIDForArrayConstraintsFromSetZustaendigkeitGebietID($zustaendigkeitGebietID))) {
            throw new \InvalidArgumentException($zustaendigkeitGebietIDArrayErrorMessage, __LINE__);
        }
        $this->zustaendigkeitGebietID = $zustaendigkeitGebietID;
        return $this;
    }
    /**
     * Add item to zustaendigkeitGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilOnlinedienst
     */
    public function addToZustaendigkeitGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The zustaendigkeitGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zustaendigkeitGebietID[] = $item;
        return $this;
    }
    /**
     * Get durchfuehrungSprache value
     * @return \StructType\Sprache[]|null
     */
    public function getDurchfuehrungSprache()
    {
        return $this->durchfuehrungSprache;
    }
    /**
     * This method is responsible for validating the values passed to the setDurchfuehrungSprache method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDurchfuehrungSprache method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurchfuehrungSpracheForArrayConstraintsFromSetDurchfuehrungSprache(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilOnlinedienstDurchfuehrungSpracheItem) {
            // validation for constraint: itemType
            if (!$suchprofilOnlinedienstDurchfuehrungSpracheItem instanceof \StructType\Sprache) {
                $invalidValues[] = is_object($suchprofilOnlinedienstDurchfuehrungSpracheItem) ? get_class($suchprofilOnlinedienstDurchfuehrungSpracheItem) : sprintf('%s(%s)', gettype($suchprofilOnlinedienstDurchfuehrungSpracheItem), var_export($suchprofilOnlinedienstDurchfuehrungSpracheItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The durchfuehrungSprache property can only contain items of type \StructType\Sprache, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set durchfuehrungSprache value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprache[] $durchfuehrungSprache
     * @return \StructType\SuchprofilOnlinedienst
     */
    public function setDurchfuehrungSprache(array $durchfuehrungSprache = array())
    {
        // validation for constraint: array
        if ('' !== ($durchfuehrungSpracheArrayErrorMessage = self::validateDurchfuehrungSpracheForArrayConstraintsFromSetDurchfuehrungSprache($durchfuehrungSprache))) {
            throw new \InvalidArgumentException($durchfuehrungSpracheArrayErrorMessage, __LINE__);
        }
        $this->durchfuehrungSprache = $durchfuehrungSprache;
        return $this;
    }
    /**
     * Add item to durchfuehrungSprache value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprache $item
     * @return \StructType\SuchprofilOnlinedienst
     */
    public function addToDurchfuehrungSprache(\StructType\Sprache $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sprache) {
            throw new \InvalidArgumentException(sprintf('The durchfuehrungSprache property can only contain items of type \StructType\Sprache, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->durchfuehrungSprache[] = $item;
        return $this;
    }
    /**
     * Get kennzeichenErweiterteAusgabe value
     * @return bool|null
     */
    public function getKennzeichenErweiterteAusgabe()
    {
        return $this->kennzeichenErweiterteAusgabe;
    }
    /**
     * Set kennzeichenErweiterteAusgabe value
     * @param bool $kennzeichenErweiterteAusgabe
     * @return \StructType\SuchprofilOnlinedienst
     */
    public function setKennzeichenErweiterteAusgabe($kennzeichenErweiterteAusgabe = false)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenErweiterteAusgabe) && !is_bool($kennzeichenErweiterteAusgabe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenErweiterteAusgabe, true), gettype($kennzeichenErweiterteAusgabe)), __LINE__);
        }
        $this->kennzeichenErweiterteAusgabe = $kennzeichenErweiterteAusgabe;
        return $this;
    }
    /**
     * Get kennzeichenNurBasisinformation value
     * @return bool|null
     */
    public function getKennzeichenNurBasisinformation()
    {
        return $this->kennzeichenNurBasisinformation;
    }
    /**
     * Set kennzeichenNurBasisinformation value
     * @param bool $kennzeichenNurBasisinformation
     * @return \StructType\SuchprofilOnlinedienst
     */
    public function setKennzeichenNurBasisinformation($kennzeichenNurBasisinformation = false)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenNurBasisinformation) && !is_bool($kennzeichenNurBasisinformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenNurBasisinformation, true), gettype($kennzeichenNurBasisinformation)), __LINE__);
        }
        $this->kennzeichenNurBasisinformation = $kennzeichenNurBasisinformation;
        return $this;
    }
}
