<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuchprofilLeistungskategorie StructType
 * Meta information extracted from the WSDL
 * - documentation: Suchprofil für Leistungskagegorien.
 * @subpackage Structs
 */
class SuchprofilLeistungskategorie extends Suchprofil
{
    /**
     * The leistungskategorieKlasseID
     * Meta information extracted from the WSDL
     * - documentation: Identifikator(en) zur Einschränkung auf Leistungskategorieklassen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $leistungskategorieKlasseID;
    /**
     * The uebergeordneteLeistungskategorieID
     * Meta information extracted from the WSDL
     * - documentation: ID der Leistungskategorie (von der die Kinder zurückgegeben werden).
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $uebergeordneteLeistungskategorieID;
    /**
     * Constructor method for SuchprofilLeistungskategorie
     * @uses SuchprofilLeistungskategorie::setLeistungskategorieKlasseID()
     * @uses SuchprofilLeistungskategorie::setUebergeordneteLeistungskategorieID()
     * @param \StructType\Identifikator[] $leistungskategorieKlasseID
     * @param \StructType\Identifikator $uebergeordneteLeistungskategorieID
     */
    public function __construct(array $leistungskategorieKlasseID = array(), \StructType\Identifikator $uebergeordneteLeistungskategorieID = null)
    {
        $this
            ->setLeistungskategorieKlasseID($leistungskategorieKlasseID)
            ->setUebergeordneteLeistungskategorieID($uebergeordneteLeistungskategorieID);
    }
    /**
     * Get leistungskategorieKlasseID value
     * @return \StructType\Identifikator[]|null
     */
    public function getLeistungskategorieKlasseID()
    {
        return $this->leistungskategorieKlasseID;
    }
    /**
     * This method is responsible for validating the values passed to the setLeistungskategorieKlasseID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistungskategorieKlasseID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeistungskategorieKlasseIDForArrayConstraintsFromSetLeistungskategorieKlasseID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungskategorieLeistungskategorieKlasseIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungskategorieLeistungskategorieKlasseIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilLeistungskategorieLeistungskategorieKlasseIDItem) ? get_class($suchprofilLeistungskategorieLeistungskategorieKlasseIDItem) : sprintf('%s(%s)', gettype($suchprofilLeistungskategorieLeistungskategorieKlasseIDItem), var_export($suchprofilLeistungskategorieLeistungskategorieKlasseIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The leistungskategorieKlasseID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set leistungskategorieKlasseID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $leistungskategorieKlasseID
     * @return \StructType\SuchprofilLeistungskategorie
     */
    public function setLeistungskategorieKlasseID(array $leistungskategorieKlasseID = array())
    {
        // validation for constraint: array
        if ('' !== ($leistungskategorieKlasseIDArrayErrorMessage = self::validateLeistungskategorieKlasseIDForArrayConstraintsFromSetLeistungskategorieKlasseID($leistungskategorieKlasseID))) {
            throw new \InvalidArgumentException($leistungskategorieKlasseIDArrayErrorMessage, __LINE__);
        }
        $this->leistungskategorieKlasseID = $leistungskategorieKlasseID;
        return $this;
    }
    /**
     * Add item to leistungskategorieKlasseID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilLeistungskategorie
     */
    public function addToLeistungskategorieKlasseID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The leistungskategorieKlasseID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->leistungskategorieKlasseID[] = $item;
        return $this;
    }
    /**
     * Get uebergeordneteLeistungskategorieID value
     * @return \StructType\Identifikator|null
     */
    public function getUebergeordneteLeistungskategorieID()
    {
        return $this->uebergeordneteLeistungskategorieID;
    }
    /**
     * Set uebergeordneteLeistungskategorieID value
     * @param \StructType\Identifikator $uebergeordneteLeistungskategorieID
     * @return \StructType\SuchprofilLeistungskategorie
     */
    public function setUebergeordneteLeistungskategorieID(\StructType\Identifikator $uebergeordneteLeistungskategorieID = null)
    {
        $this->uebergeordneteLeistungskategorieID = $uebergeordneteLeistungskategorieID;
        return $this;
    }
}
