<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuchprofilLeistungsbericht StructType
 * Meta information extracted from the WSDL
 * - documentation: Suchprofil für Leistungsberichte. Die Suchparameter bestimmen direkt die Leistungen und indirekt die übermittelten Organisationseinheiten. Zu Leistungen werden Organisationseinheiten, welche für die Leistungen zuständig sind
 * ermittelt. Alle Parameter werden UND-verknüpft. Spezialisierungsinformationen zu Leistungen sollen - sofern vorhanden - ausgegeben werden, wenn das Zuständigkeitsgebiet bekannt ist.
 * @subpackage Structs
 */
class SuchprofilLeistungsbericht extends AbstractStructBase
{
    /**
     * The herausgeberID
     * Meta information extracted from the WSDL
     * - documentation: ID eines bestimmten Herausgebers/Teilnehmers von welchen die Leistungen betrachtet werden sollen. Hier kann z.B. eine 115-Teilnehmernummer angegeben werden.
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $herausgeberID;
    /**
     * The leistungID
     * Meta information extracted from the WSDL
     * - documentation: Angabe von IDs von Leistungen. Es wird in den primären und (wenn vorhanden) in sekundären IDs gesucht. Angegebene IDs werden hier "ODER" verknüpft.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $leistungID;
    /**
     * The leistungskategorie
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Leistungskategorien der Leistungen, auf welche das Suchergebnis eingeschränkt werden soll.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SuchparameterKategorie[]
     */
    public $leistungskategorie;
    /**
     * The suchbegriff
     * Meta information extracted from the WSDL
     * - documentation: Suchbegriff wird in Bezeichnungsmodulen sowie Begriffen im Kontext für Leistungen gesucht.
     * - minOccurs: 0
     * @var \StructType\String_Localized
     */
    public $suchbegriff;
    /**
     * The kennzeichenVolltext
     * Meta information extracted from the WSDL
     * - documentation: Suchbegriff wird zusätzlich in allen Modulen einer Leistung gesucht.
     * - minOccurs: 0
     * @var bool
     */
    public $kennzeichenVolltext;
    /**
     * The standortGebietID
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Gebieten in Adressen (Standortsuche). Es werden Leistungen ermittelt, welche in Zuständigkeiten für Organisationseinheiten mit Adressen in diesem Gebieten vorhanden sind. Hierbei spielen die Zuständigkeitsgebiete keine
     * Rolle und können unterschiedlich sein.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $standortGebietID;
    /**
     * The zustaendigkeitGebietID
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Gebieten, für welche Leistungen in Zuständigkeiten von Organisationseinheiten existieren müssen. Achtung: Es muss hier unbedingt die räumliche Zuständigkeit beachtet werden. Beispiel: Wird hier das Gebiet
     * "Sachsen-Anhalt" angegeben, dürfen auch nur OEs, welche für ganz Sachsen-Anhalt zuständig sind, ausgegeben werden. Zum Beispiel Ministerien, Landesverwaltungsamt etc. Oder wird eine spezielle Gemeinde angegeben, müssen auch Zuständigkeiten in
     * den darüberliegenden Gebieten ermittelt werden, z.B. Landkreis und Bundesland. D.h. die Suche wird im Gebietsbaum nach oben bis zur Wurzel durchgeführt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $zustaendigkeitGebietID;
    /**
     * The gueltigkeitszeitraum
     * Meta information extracted from the WSDL
     * - documentation: Parameter zur Steuerung der Gültigkeitszeiträume der Suchergebnisse.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeitszeitraum;
    /**
     * The aenderungszeitraum
     * Meta information extracted from the WSDL
     * - documentation: Angabe eines Zeitraums nach dem Änderungsdatum von Objekten. Es werden dann nur die Ergebnisse geliefert, welche im angegebenen Zeitraum geändert wurden. Dies gilt hier für Leistungen (da Leistungsbericht) und nicht für
     * Organisationseinheiten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $aenderungszeitraum;
    /**
     * Constructor method for SuchprofilLeistungsbericht
     * @uses SuchprofilLeistungsbericht::setHerausgeberID()
     * @uses SuchprofilLeistungsbericht::setLeistungID()
     * @uses SuchprofilLeistungsbericht::setLeistungskategorie()
     * @uses SuchprofilLeistungsbericht::setSuchbegriff()
     * @uses SuchprofilLeistungsbericht::setKennzeichenVolltext()
     * @uses SuchprofilLeistungsbericht::setStandortGebietID()
     * @uses SuchprofilLeistungsbericht::setZustaendigkeitGebietID()
     * @uses SuchprofilLeistungsbericht::setGueltigkeitszeitraum()
     * @uses SuchprofilLeistungsbericht::setAenderungszeitraum()
     * @param \StructType\Identifikator $herausgeberID
     * @param \StructType\Identifikator[] $leistungID
     * @param \StructType\SuchparameterKategorie[] $leistungskategorie
     * @param \StructType\String_Localized $suchbegriff
     * @param bool $kennzeichenVolltext
     * @param \StructType\Identifikator[] $standortGebietID
     * @param \StructType\Identifikator[] $zustaendigkeitGebietID
     * @param \StructType\Zeitraum[] $gueltigkeitszeitraum
     * @param \StructType\Zeitraum[] $aenderungszeitraum
     */
    public function __construct(\StructType\Identifikator $herausgeberID = null, array $leistungID = array(), array $leistungskategorie = array(), \StructType\String_Localized $suchbegriff = null, $kennzeichenVolltext = null, array $standortGebietID = array(), array $zustaendigkeitGebietID = array(), array $gueltigkeitszeitraum = array(), array $aenderungszeitraum = array())
    {
        $this
            ->setHerausgeberID($herausgeberID)
            ->setLeistungID($leistungID)
            ->setLeistungskategorie($leistungskategorie)
            ->setSuchbegriff($suchbegriff)
            ->setKennzeichenVolltext($kennzeichenVolltext)
            ->setStandortGebietID($standortGebietID)
            ->setZustaendigkeitGebietID($zustaendigkeitGebietID)
            ->setGueltigkeitszeitraum($gueltigkeitszeitraum)
            ->setAenderungszeitraum($aenderungszeitraum);
    }
    /**
     * Get herausgeberID value
     * @return \StructType\Identifikator|null
     */
    public function getHerausgeberID()
    {
        return $this->herausgeberID;
    }
    /**
     * Set herausgeberID value
     * @param \StructType\Identifikator $herausgeberID
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function setHerausgeberID(\StructType\Identifikator $herausgeberID = null)
    {
        $this->herausgeberID = $herausgeberID;
        return $this;
    }
    /**
     * Get leistungID value
     * @return \StructType\Identifikator[]|null
     */
    public function getLeistungID()
    {
        return $this->leistungID;
    }
    /**
     * This method is responsible for validating the values passed to the setLeistungID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistungID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeistungIDForArrayConstraintsFromSetLeistungID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungsberichtLeistungIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungsberichtLeistungIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilLeistungsberichtLeistungIDItem) ? get_class($suchprofilLeistungsberichtLeistungIDItem) : sprintf('%s(%s)', gettype($suchprofilLeistungsberichtLeistungIDItem), var_export($suchprofilLeistungsberichtLeistungIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The leistungID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set leistungID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $leistungID
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function setLeistungID(array $leistungID = array())
    {
        // validation for constraint: array
        if ('' !== ($leistungIDArrayErrorMessage = self::validateLeistungIDForArrayConstraintsFromSetLeistungID($leistungID))) {
            throw new \InvalidArgumentException($leistungIDArrayErrorMessage, __LINE__);
        }
        $this->leistungID = $leistungID;
        return $this;
    }
    /**
     * Add item to leistungID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function addToLeistungID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The leistungID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->leistungID[] = $item;
        return $this;
    }
    /**
     * Get leistungskategorie value
     * @return \StructType\SuchparameterKategorie[]|null
     */
    public function getLeistungskategorie()
    {
        return $this->leistungskategorie;
    }
    /**
     * This method is responsible for validating the values passed to the setLeistungskategorie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistungskategorie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeistungskategorieForArrayConstraintsFromSetLeistungskategorie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungsberichtLeistungskategorieItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungsberichtLeistungskategorieItem instanceof \StructType\SuchparameterKategorie) {
                $invalidValues[] = is_object($suchprofilLeistungsberichtLeistungskategorieItem) ? get_class($suchprofilLeistungsberichtLeistungskategorieItem) : sprintf('%s(%s)', gettype($suchprofilLeistungsberichtLeistungskategorieItem), var_export($suchprofilLeistungsberichtLeistungskategorieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The leistungskategorie property can only contain items of type \StructType\SuchparameterKategorie, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set leistungskategorie value
     * @throws \InvalidArgumentException
     * @param \StructType\SuchparameterKategorie[] $leistungskategorie
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function setLeistungskategorie(array $leistungskategorie = array())
    {
        // validation for constraint: array
        if ('' !== ($leistungskategorieArrayErrorMessage = self::validateLeistungskategorieForArrayConstraintsFromSetLeistungskategorie($leistungskategorie))) {
            throw new \InvalidArgumentException($leistungskategorieArrayErrorMessage, __LINE__);
        }
        $this->leistungskategorie = $leistungskategorie;
        return $this;
    }
    /**
     * Add item to leistungskategorie value
     * @throws \InvalidArgumentException
     * @param \StructType\SuchparameterKategorie $item
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function addToLeistungskategorie(\StructType\SuchparameterKategorie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SuchparameterKategorie) {
            throw new \InvalidArgumentException(sprintf('The leistungskategorie property can only contain items of type \StructType\SuchparameterKategorie, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->leistungskategorie[] = $item;
        return $this;
    }
    /**
     * Get suchbegriff value
     * @return \StructType\String_Localized|null
     */
    public function getSuchbegriff()
    {
        return $this->suchbegriff;
    }
    /**
     * Set suchbegriff value
     * @param \StructType\String_Localized $suchbegriff
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function setSuchbegriff(\StructType\String_Localized $suchbegriff = null)
    {
        $this->suchbegriff = $suchbegriff;
        return $this;
    }
    /**
     * Get kennzeichenVolltext value
     * @return bool|null
     */
    public function getKennzeichenVolltext()
    {
        return $this->kennzeichenVolltext;
    }
    /**
     * Set kennzeichenVolltext value
     * @param bool $kennzeichenVolltext
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function setKennzeichenVolltext($kennzeichenVolltext = null)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenVolltext) && !is_bool($kennzeichenVolltext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenVolltext, true), gettype($kennzeichenVolltext)), __LINE__);
        }
        $this->kennzeichenVolltext = $kennzeichenVolltext;
        return $this;
    }
    /**
     * Get standortGebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getStandortGebietID()
    {
        return $this->standortGebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setStandortGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStandortGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStandortGebietIDForArrayConstraintsFromSetStandortGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungsberichtStandortGebietIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungsberichtStandortGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilLeistungsberichtStandortGebietIDItem) ? get_class($suchprofilLeistungsberichtStandortGebietIDItem) : sprintf('%s(%s)', gettype($suchprofilLeistungsberichtStandortGebietIDItem), var_export($suchprofilLeistungsberichtStandortGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The standortGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set standortGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $standortGebietID
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function setStandortGebietID(array $standortGebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($standortGebietIDArrayErrorMessage = self::validateStandortGebietIDForArrayConstraintsFromSetStandortGebietID($standortGebietID))) {
            throw new \InvalidArgumentException($standortGebietIDArrayErrorMessage, __LINE__);
        }
        $this->standortGebietID = $standortGebietID;
        return $this;
    }
    /**
     * Add item to standortGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function addToStandortGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The standortGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->standortGebietID[] = $item;
        return $this;
    }
    /**
     * Get zustaendigkeitGebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getZustaendigkeitGebietID()
    {
        return $this->zustaendigkeitGebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setZustaendigkeitGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZustaendigkeitGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZustaendigkeitGebietIDForArrayConstraintsFromSetZustaendigkeitGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungsberichtZustaendigkeitGebietIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungsberichtZustaendigkeitGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilLeistungsberichtZustaendigkeitGebietIDItem) ? get_class($suchprofilLeistungsberichtZustaendigkeitGebietIDItem) : sprintf('%s(%s)', gettype($suchprofilLeistungsberichtZustaendigkeitGebietIDItem), var_export($suchprofilLeistungsberichtZustaendigkeitGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zustaendigkeitGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zustaendigkeitGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $zustaendigkeitGebietID
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function setZustaendigkeitGebietID(array $zustaendigkeitGebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($zustaendigkeitGebietIDArrayErrorMessage = self::validateZustaendigkeitGebietIDForArrayConstraintsFromSetZustaendigkeitGebietID($zustaendigkeitGebietID))) {
            throw new \InvalidArgumentException($zustaendigkeitGebietIDArrayErrorMessage, __LINE__);
        }
        $this->zustaendigkeitGebietID = $zustaendigkeitGebietID;
        return $this;
    }
    /**
     * Add item to zustaendigkeitGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function addToZustaendigkeitGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The zustaendigkeitGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zustaendigkeitGebietID[] = $item;
        return $this;
    }
    /**
     * Get gueltigkeitszeitraum value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeitszeitraum()
    {
        return $this->gueltigkeitszeitraum;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeitszeitraum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeitszeitraum method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitszeitraumForArrayConstraintsFromSetGueltigkeitszeitraum(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungsberichtGueltigkeitszeitraumItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungsberichtGueltigkeitszeitraumItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($suchprofilLeistungsberichtGueltigkeitszeitraumItem) ? get_class($suchprofilLeistungsberichtGueltigkeitszeitraumItem) : sprintf('%s(%s)', gettype($suchprofilLeistungsberichtGueltigkeitszeitraumItem), var_export($suchprofilLeistungsberichtGueltigkeitszeitraumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeitszeitraum property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeitszeitraum value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeitszeitraum
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function setGueltigkeitszeitraum(array $gueltigkeitszeitraum = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitszeitraumArrayErrorMessage = self::validateGueltigkeitszeitraumForArrayConstraintsFromSetGueltigkeitszeitraum($gueltigkeitszeitraum))) {
            throw new \InvalidArgumentException($gueltigkeitszeitraumArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeitszeitraum = $gueltigkeitszeitraum;
        return $this;
    }
    /**
     * Add item to gueltigkeitszeitraum value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function addToGueltigkeitszeitraum(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeitszeitraum property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeitszeitraum[] = $item;
        return $this;
    }
    /**
     * Get aenderungszeitraum value
     * @return \StructType\Zeitraum[]|null
     */
    public function getAenderungszeitraum()
    {
        return $this->aenderungszeitraum;
    }
    /**
     * This method is responsible for validating the values passed to the setAenderungszeitraum method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAenderungszeitraum method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAenderungszeitraumForArrayConstraintsFromSetAenderungszeitraum(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungsberichtAenderungszeitraumItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungsberichtAenderungszeitraumItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($suchprofilLeistungsberichtAenderungszeitraumItem) ? get_class($suchprofilLeistungsberichtAenderungszeitraumItem) : sprintf('%s(%s)', gettype($suchprofilLeistungsberichtAenderungszeitraumItem), var_export($suchprofilLeistungsberichtAenderungszeitraumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The aenderungszeitraum property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set aenderungszeitraum value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $aenderungszeitraum
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function setAenderungszeitraum(array $aenderungszeitraum = array())
    {
        // validation for constraint: array
        if ('' !== ($aenderungszeitraumArrayErrorMessage = self::validateAenderungszeitraumForArrayConstraintsFromSetAenderungszeitraum($aenderungszeitraum))) {
            throw new \InvalidArgumentException($aenderungszeitraumArrayErrorMessage, __LINE__);
        }
        $this->aenderungszeitraum = $aenderungszeitraum;
        return $this;
    }
    /**
     * Add item to aenderungszeitraum value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\SuchprofilLeistungsbericht
     */
    public function addToAenderungszeitraum(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The aenderungszeitraum property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->aenderungszeitraum[] = $item;
        return $this;
    }
}
