<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuchprofilLeistung StructType
 * Meta information extracted from the WSDL
 * - documentation: Suchprofil für Leistungen.
 * @subpackage Structs
 */
class SuchprofilLeistung extends Suchprofil
{
    /**
     * The leistungskategorie
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Leistungskategorien der Leistungen, auf welche das Suchergebnis eingeschränkt werden soll.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SuchparameterKategorie[]
     */
    public $leistungskategorie;
    /**
     * The leistungsklasse
     * Meta information extracted from the WSDL
     * - documentation: Zur Einschränkung auf bestimmte Leistungsklassen. Es ist hier anzumerken, dass immer die konkrete Ableitung bestimmt wird. D.h. wenn z.B. "Leistung", dann werden nur Klassen vom Typ "Leistung" zurückgegeben und nicht Ableitungen
     * davon, wie "Leistungsobjekt".
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_Leistungsklasse[]
     */
    public $leistungsklasse;
    /**
     * The leistungsverrichtung
     * Meta information extracted from the WSDL
     * - documentation: Die Angabe der Verrichtung zur Einschränkung des Suchergebnisses auf Leistungen vom Typ LOV oder LOVD mit diesen Verrichtungen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LeistungsverrichtungAuswahlID[]
     */
    public $leistungsverrichtung;
    /**
     * The gueltigkeitGebietID
     * Meta information extracted from the WSDL
     * - documentation: Einschränkung auf bestimmte Gebiete, für welche die zurückgegebenen Leistungen gültig sein sollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $gueltigkeitGebietID;
    /**
     * The spezialisiereFuerGebietID
     * Meta information extracted from the WSDL
     * - documentation: Wenn Leistungsinhalte für ein Gebiet spezialisiert werden sollen, wird hier die ID des gewünschten Gebietes (in der Regel der Wohnort) angegeben. Es müssen dann alle Spezialisierungsinhalte in die Leistungsmodule
     * eingefügt/hereingerendert werden. Dies ist z.B. nützlich, wenn die Leistung direkt präsentiert werden soll.
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $spezialisiereFuerGebietID;
    /**
     * The wirtschaftszweigCode
     * Meta information extracted from the WSDL
     * - documentation: Code der Wirtschaftszweige. Nur Leistungen, die für diese Wirtschaftszweige relevant sind, werden zurückgegeben.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Wirtschaftszweig_Spezifizierbar[]
     */
    public $wirtschaftszweigCode;
    /**
     * The staatsangehoerigkeitCode
     * Meta information extracted from the WSDL
     * - documentation: Code der Staatsangehörigkeiten. Nur Leistungen, die für diese Staatsangehörigkeiten relevant sind, werden zurückgegeben.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_StaatsangehoerigkeitDestatis[]
     */
    public $staatsangehoerigkeitCode;
    /**
     * The rechtsformCode
     * Meta information extracted from the WSDL
     * - documentation: Code der Rechtsformen. Nur Leistungen, die für diese Rechtsformen relevant sind, werden zurückgegeben.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_Rechtsform[]
     */
    public $rechtsformCode;
    /**
     * The kennzeichenNurBasisinformation
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob nur Basisinformationen zurückgegeben werden soll. In NachrichtenAntworten wird dann anstatt des eigentlichen Objekts das BasisinformationObjekt zurückgegeben.
     * - default: false
     * @var bool
     */
    public $kennzeichenNurBasisinformation;
    /**
     * Constructor method for SuchprofilLeistung
     * @uses SuchprofilLeistung::setLeistungskategorie()
     * @uses SuchprofilLeistung::setLeistungsklasse()
     * @uses SuchprofilLeistung::setLeistungsverrichtung()
     * @uses SuchprofilLeistung::setGueltigkeitGebietID()
     * @uses SuchprofilLeistung::setSpezialisiereFuerGebietID()
     * @uses SuchprofilLeistung::setWirtschaftszweigCode()
     * @uses SuchprofilLeistung::setStaatsangehoerigkeitCode()
     * @uses SuchprofilLeistung::setRechtsformCode()
     * @uses SuchprofilLeistung::setKennzeichenNurBasisinformation()
     * @param \StructType\SuchparameterKategorie[] $leistungskategorie
     * @param \StructType\Code_Leistungsklasse[] $leistungsklasse
     * @param \StructType\LeistungsverrichtungAuswahlID[] $leistungsverrichtung
     * @param \StructType\Identifikator[] $gueltigkeitGebietID
     * @param \StructType\Identifikator $spezialisiereFuerGebietID
     * @param \StructType\Wirtschaftszweig_Spezifizierbar[] $wirtschaftszweigCode
     * @param \StructType\Code_StaatsangehoerigkeitDestatis[] $staatsangehoerigkeitCode
     * @param \StructType\Code_Rechtsform[] $rechtsformCode
     * @param bool $kennzeichenNurBasisinformation
     */
    public function __construct(array $leistungskategorie = array(), array $leistungsklasse = array(), array $leistungsverrichtung = array(), array $gueltigkeitGebietID = array(), \StructType\Identifikator $spezialisiereFuerGebietID = null, array $wirtschaftszweigCode = array(), array $staatsangehoerigkeitCode = array(), array $rechtsformCode = array(), $kennzeichenNurBasisinformation = false)
    {
        $this
            ->setLeistungskategorie($leistungskategorie)
            ->setLeistungsklasse($leistungsklasse)
            ->setLeistungsverrichtung($leistungsverrichtung)
            ->setGueltigkeitGebietID($gueltigkeitGebietID)
            ->setSpezialisiereFuerGebietID($spezialisiereFuerGebietID)
            ->setWirtschaftszweigCode($wirtschaftszweigCode)
            ->setStaatsangehoerigkeitCode($staatsangehoerigkeitCode)
            ->setRechtsformCode($rechtsformCode)
            ->setKennzeichenNurBasisinformation($kennzeichenNurBasisinformation);
    }
    /**
     * Get leistungskategorie value
     * @return \StructType\SuchparameterKategorie[]|null
     */
    public function getLeistungskategorie()
    {
        return $this->leistungskategorie;
    }
    /**
     * This method is responsible for validating the values passed to the setLeistungskategorie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistungskategorie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeistungskategorieForArrayConstraintsFromSetLeistungskategorie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungLeistungskategorieItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungLeistungskategorieItem instanceof \StructType\SuchparameterKategorie) {
                $invalidValues[] = is_object($suchprofilLeistungLeistungskategorieItem) ? get_class($suchprofilLeistungLeistungskategorieItem) : sprintf('%s(%s)', gettype($suchprofilLeistungLeistungskategorieItem), var_export($suchprofilLeistungLeistungskategorieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The leistungskategorie property can only contain items of type \StructType\SuchparameterKategorie, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set leistungskategorie value
     * @throws \InvalidArgumentException
     * @param \StructType\SuchparameterKategorie[] $leistungskategorie
     * @return \StructType\SuchprofilLeistung
     */
    public function setLeistungskategorie(array $leistungskategorie = array())
    {
        // validation for constraint: array
        if ('' !== ($leistungskategorieArrayErrorMessage = self::validateLeistungskategorieForArrayConstraintsFromSetLeistungskategorie($leistungskategorie))) {
            throw new \InvalidArgumentException($leistungskategorieArrayErrorMessage, __LINE__);
        }
        $this->leistungskategorie = $leistungskategorie;
        return $this;
    }
    /**
     * Add item to leistungskategorie value
     * @throws \InvalidArgumentException
     * @param \StructType\SuchparameterKategorie $item
     * @return \StructType\SuchprofilLeistung
     */
    public function addToLeistungskategorie(\StructType\SuchparameterKategorie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SuchparameterKategorie) {
            throw new \InvalidArgumentException(sprintf('The leistungskategorie property can only contain items of type \StructType\SuchparameterKategorie, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->leistungskategorie[] = $item;
        return $this;
    }
    /**
     * Get leistungsklasse value
     * @return \StructType\Code_Leistungsklasse[]|null
     */
    public function getLeistungsklasse()
    {
        return $this->leistungsklasse;
    }
    /**
     * This method is responsible for validating the values passed to the setLeistungsklasse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistungsklasse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeistungsklasseForArrayConstraintsFromSetLeistungsklasse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungLeistungsklasseItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungLeistungsklasseItem instanceof \StructType\Code_Leistungsklasse) {
                $invalidValues[] = is_object($suchprofilLeistungLeistungsklasseItem) ? get_class($suchprofilLeistungLeistungsklasseItem) : sprintf('%s(%s)', gettype($suchprofilLeistungLeistungsklasseItem), var_export($suchprofilLeistungLeistungsklasseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The leistungsklasse property can only contain items of type \StructType\Code_Leistungsklasse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set leistungsklasse value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Leistungsklasse[] $leistungsklasse
     * @return \StructType\SuchprofilLeistung
     */
    public function setLeistungsklasse(array $leistungsklasse = array())
    {
        // validation for constraint: array
        if ('' !== ($leistungsklasseArrayErrorMessage = self::validateLeistungsklasseForArrayConstraintsFromSetLeistungsklasse($leistungsklasse))) {
            throw new \InvalidArgumentException($leistungsklasseArrayErrorMessage, __LINE__);
        }
        $this->leistungsklasse = $leistungsklasse;
        return $this;
    }
    /**
     * Add item to leistungsklasse value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Leistungsklasse $item
     * @return \StructType\SuchprofilLeistung
     */
    public function addToLeistungsklasse(\StructType\Code_Leistungsklasse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_Leistungsklasse) {
            throw new \InvalidArgumentException(sprintf('The leistungsklasse property can only contain items of type \StructType\Code_Leistungsklasse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->leistungsklasse[] = $item;
        return $this;
    }
    /**
     * Get leistungsverrichtung value
     * @return \StructType\LeistungsverrichtungAuswahlID[]|null
     */
    public function getLeistungsverrichtung()
    {
        return $this->leistungsverrichtung;
    }
    /**
     * This method is responsible for validating the values passed to the setLeistungsverrichtung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistungsverrichtung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeistungsverrichtungForArrayConstraintsFromSetLeistungsverrichtung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungLeistungsverrichtungItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungLeistungsverrichtungItem instanceof \StructType\LeistungsverrichtungAuswahlID) {
                $invalidValues[] = is_object($suchprofilLeistungLeistungsverrichtungItem) ? get_class($suchprofilLeistungLeistungsverrichtungItem) : sprintf('%s(%s)', gettype($suchprofilLeistungLeistungsverrichtungItem), var_export($suchprofilLeistungLeistungsverrichtungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The leistungsverrichtung property can only contain items of type \StructType\LeistungsverrichtungAuswahlID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set leistungsverrichtung value
     * @throws \InvalidArgumentException
     * @param \StructType\LeistungsverrichtungAuswahlID[] $leistungsverrichtung
     * @return \StructType\SuchprofilLeistung
     */
    public function setLeistungsverrichtung(array $leistungsverrichtung = array())
    {
        // validation for constraint: array
        if ('' !== ($leistungsverrichtungArrayErrorMessage = self::validateLeistungsverrichtungForArrayConstraintsFromSetLeistungsverrichtung($leistungsverrichtung))) {
            throw new \InvalidArgumentException($leistungsverrichtungArrayErrorMessage, __LINE__);
        }
        $this->leistungsverrichtung = $leistungsverrichtung;
        return $this;
    }
    /**
     * Add item to leistungsverrichtung value
     * @throws \InvalidArgumentException
     * @param \StructType\LeistungsverrichtungAuswahlID $item
     * @return \StructType\SuchprofilLeistung
     */
    public function addToLeistungsverrichtung(\StructType\LeistungsverrichtungAuswahlID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LeistungsverrichtungAuswahlID) {
            throw new \InvalidArgumentException(sprintf('The leistungsverrichtung property can only contain items of type \StructType\LeistungsverrichtungAuswahlID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->leistungsverrichtung[] = $item;
        return $this;
    }
    /**
     * Get gueltigkeitGebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getGueltigkeitGebietID()
    {
        return $this->gueltigkeitGebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeitGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeitGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitGebietIDForArrayConstraintsFromSetGueltigkeitGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungGueltigkeitGebietIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungGueltigkeitGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilLeistungGueltigkeitGebietIDItem) ? get_class($suchprofilLeistungGueltigkeitGebietIDItem) : sprintf('%s(%s)', gettype($suchprofilLeistungGueltigkeitGebietIDItem), var_export($suchprofilLeistungGueltigkeitGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeitGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeitGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $gueltigkeitGebietID
     * @return \StructType\SuchprofilLeistung
     */
    public function setGueltigkeitGebietID(array $gueltigkeitGebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitGebietIDArrayErrorMessage = self::validateGueltigkeitGebietIDForArrayConstraintsFromSetGueltigkeitGebietID($gueltigkeitGebietID))) {
            throw new \InvalidArgumentException($gueltigkeitGebietIDArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeitGebietID = $gueltigkeitGebietID;
        return $this;
    }
    /**
     * Add item to gueltigkeitGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilLeistung
     */
    public function addToGueltigkeitGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeitGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeitGebietID[] = $item;
        return $this;
    }
    /**
     * Get spezialisiereFuerGebietID value
     * @return \StructType\Identifikator|null
     */
    public function getSpezialisiereFuerGebietID()
    {
        return $this->spezialisiereFuerGebietID;
    }
    /**
     * Set spezialisiereFuerGebietID value
     * @param \StructType\Identifikator $spezialisiereFuerGebietID
     * @return \StructType\SuchprofilLeistung
     */
    public function setSpezialisiereFuerGebietID(\StructType\Identifikator $spezialisiereFuerGebietID = null)
    {
        $this->spezialisiereFuerGebietID = $spezialisiereFuerGebietID;
        return $this;
    }
    /**
     * Get wirtschaftszweigCode value
     * @return \StructType\Wirtschaftszweig_Spezifizierbar[]|null
     */
    public function getWirtschaftszweigCode()
    {
        return $this->wirtschaftszweigCode;
    }
    /**
     * This method is responsible for validating the values passed to the setWirtschaftszweigCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWirtschaftszweigCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWirtschaftszweigCodeForArrayConstraintsFromSetWirtschaftszweigCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungWirtschaftszweigCodeItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungWirtschaftszweigCodeItem instanceof \StructType\Wirtschaftszweig_Spezifizierbar) {
                $invalidValues[] = is_object($suchprofilLeistungWirtschaftszweigCodeItem) ? get_class($suchprofilLeistungWirtschaftszweigCodeItem) : sprintf('%s(%s)', gettype($suchprofilLeistungWirtschaftszweigCodeItem), var_export($suchprofilLeistungWirtschaftszweigCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The wirtschaftszweigCode property can only contain items of type \StructType\Wirtschaftszweig_Spezifizierbar, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set wirtschaftszweigCode value
     * @throws \InvalidArgumentException
     * @param \StructType\Wirtschaftszweig_Spezifizierbar[] $wirtschaftszweigCode
     * @return \StructType\SuchprofilLeistung
     */
    public function setWirtschaftszweigCode(array $wirtschaftszweigCode = array())
    {
        // validation for constraint: array
        if ('' !== ($wirtschaftszweigCodeArrayErrorMessage = self::validateWirtschaftszweigCodeForArrayConstraintsFromSetWirtschaftszweigCode($wirtschaftszweigCode))) {
            throw new \InvalidArgumentException($wirtschaftszweigCodeArrayErrorMessage, __LINE__);
        }
        $this->wirtschaftszweigCode = $wirtschaftszweigCode;
        return $this;
    }
    /**
     * Add item to wirtschaftszweigCode value
     * @throws \InvalidArgumentException
     * @param \StructType\Wirtschaftszweig_Spezifizierbar $item
     * @return \StructType\SuchprofilLeistung
     */
    public function addToWirtschaftszweigCode(\StructType\Wirtschaftszweig_Spezifizierbar $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Wirtschaftszweig_Spezifizierbar) {
            throw new \InvalidArgumentException(sprintf('The wirtschaftszweigCode property can only contain items of type \StructType\Wirtschaftszweig_Spezifizierbar, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->wirtschaftszweigCode[] = $item;
        return $this;
    }
    /**
     * Get staatsangehoerigkeitCode value
     * @return \StructType\Code_StaatsangehoerigkeitDestatis[]|null
     */
    public function getStaatsangehoerigkeitCode()
    {
        return $this->staatsangehoerigkeitCode;
    }
    /**
     * This method is responsible for validating the values passed to the setStaatsangehoerigkeitCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStaatsangehoerigkeitCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStaatsangehoerigkeitCodeForArrayConstraintsFromSetStaatsangehoerigkeitCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungStaatsangehoerigkeitCodeItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungStaatsangehoerigkeitCodeItem instanceof \StructType\Code_StaatsangehoerigkeitDestatis) {
                $invalidValues[] = is_object($suchprofilLeistungStaatsangehoerigkeitCodeItem) ? get_class($suchprofilLeistungStaatsangehoerigkeitCodeItem) : sprintf('%s(%s)', gettype($suchprofilLeistungStaatsangehoerigkeitCodeItem), var_export($suchprofilLeistungStaatsangehoerigkeitCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The staatsangehoerigkeitCode property can only contain items of type \StructType\Code_StaatsangehoerigkeitDestatis, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set staatsangehoerigkeitCode value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_StaatsangehoerigkeitDestatis[] $staatsangehoerigkeitCode
     * @return \StructType\SuchprofilLeistung
     */
    public function setStaatsangehoerigkeitCode(array $staatsangehoerigkeitCode = array())
    {
        // validation for constraint: array
        if ('' !== ($staatsangehoerigkeitCodeArrayErrorMessage = self::validateStaatsangehoerigkeitCodeForArrayConstraintsFromSetStaatsangehoerigkeitCode($staatsangehoerigkeitCode))) {
            throw new \InvalidArgumentException($staatsangehoerigkeitCodeArrayErrorMessage, __LINE__);
        }
        $this->staatsangehoerigkeitCode = $staatsangehoerigkeitCode;
        return $this;
    }
    /**
     * Add item to staatsangehoerigkeitCode value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_StaatsangehoerigkeitDestatis $item
     * @return \StructType\SuchprofilLeistung
     */
    public function addToStaatsangehoerigkeitCode(\StructType\Code_StaatsangehoerigkeitDestatis $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_StaatsangehoerigkeitDestatis) {
            throw new \InvalidArgumentException(sprintf('The staatsangehoerigkeitCode property can only contain items of type \StructType\Code_StaatsangehoerigkeitDestatis, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->staatsangehoerigkeitCode[] = $item;
        return $this;
    }
    /**
     * Get rechtsformCode value
     * @return \StructType\Code_Rechtsform[]|null
     */
    public function getRechtsformCode()
    {
        return $this->rechtsformCode;
    }
    /**
     * This method is responsible for validating the values passed to the setRechtsformCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRechtsformCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRechtsformCodeForArrayConstraintsFromSetRechtsformCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilLeistungRechtsformCodeItem) {
            // validation for constraint: itemType
            if (!$suchprofilLeistungRechtsformCodeItem instanceof \StructType\Code_Rechtsform) {
                $invalidValues[] = is_object($suchprofilLeistungRechtsformCodeItem) ? get_class($suchprofilLeistungRechtsformCodeItem) : sprintf('%s(%s)', gettype($suchprofilLeistungRechtsformCodeItem), var_export($suchprofilLeistungRechtsformCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The rechtsformCode property can only contain items of type \StructType\Code_Rechtsform, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set rechtsformCode value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Rechtsform[] $rechtsformCode
     * @return \StructType\SuchprofilLeistung
     */
    public function setRechtsformCode(array $rechtsformCode = array())
    {
        // validation for constraint: array
        if ('' !== ($rechtsformCodeArrayErrorMessage = self::validateRechtsformCodeForArrayConstraintsFromSetRechtsformCode($rechtsformCode))) {
            throw new \InvalidArgumentException($rechtsformCodeArrayErrorMessage, __LINE__);
        }
        $this->rechtsformCode = $rechtsformCode;
        return $this;
    }
    /**
     * Add item to rechtsformCode value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Rechtsform $item
     * @return \StructType\SuchprofilLeistung
     */
    public function addToRechtsformCode(\StructType\Code_Rechtsform $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_Rechtsform) {
            throw new \InvalidArgumentException(sprintf('The rechtsformCode property can only contain items of type \StructType\Code_Rechtsform, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->rechtsformCode[] = $item;
        return $this;
    }
    /**
     * Get kennzeichenNurBasisinformation value
     * @return bool|null
     */
    public function getKennzeichenNurBasisinformation()
    {
        return $this->kennzeichenNurBasisinformation;
    }
    /**
     * Set kennzeichenNurBasisinformation value
     * @param bool $kennzeichenNurBasisinformation
     * @return \StructType\SuchprofilLeistung
     */
    public function setKennzeichenNurBasisinformation($kennzeichenNurBasisinformation = false)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenNurBasisinformation) && !is_bool($kennzeichenNurBasisinformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenNurBasisinformation, true), gettype($kennzeichenNurBasisinformation)), __LINE__);
        }
        $this->kennzeichenNurBasisinformation = $kennzeichenNurBasisinformation;
        return $this;
    }
}
