<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuchprofilHerausgeber StructType
 * Meta information extracted from the WSDL
 * - documentation: Suchprofil für Herausgeber.
 * @subpackage Structs
 */
class SuchprofilHerausgeber extends Suchprofil
{
    /**
     * The standardZustaendigkeitsgebiet
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Gebieten, welche im Standardzuständigkeitsgebiet des Herausgebers enthalten sein müssen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Gebiet[]
     */
    public $standardZustaendigkeitsgebiet;
    /**
     * Constructor method for SuchprofilHerausgeber
     * @uses SuchprofilHerausgeber::setStandardZustaendigkeitsgebiet()
     * @param \StructType\Gebiet[] $standardZustaendigkeitsgebiet
     */
    public function __construct(array $standardZustaendigkeitsgebiet = array())
    {
        $this
            ->setStandardZustaendigkeitsgebiet($standardZustaendigkeitsgebiet);
    }
    /**
     * Get standardZustaendigkeitsgebiet value
     * @return \StructType\Gebiet[]|null
     */
    public function getStandardZustaendigkeitsgebiet()
    {
        return $this->standardZustaendigkeitsgebiet;
    }
    /**
     * This method is responsible for validating the values passed to the setStandardZustaendigkeitsgebiet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStandardZustaendigkeitsgebiet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStandardZustaendigkeitsgebietForArrayConstraintsFromSetStandardZustaendigkeitsgebiet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilHerausgeberStandardZustaendigkeitsgebietItem) {
            // validation for constraint: itemType
            if (!$suchprofilHerausgeberStandardZustaendigkeitsgebietItem instanceof \StructType\Gebiet) {
                $invalidValues[] = is_object($suchprofilHerausgeberStandardZustaendigkeitsgebietItem) ? get_class($suchprofilHerausgeberStandardZustaendigkeitsgebietItem) : sprintf('%s(%s)', gettype($suchprofilHerausgeberStandardZustaendigkeitsgebietItem), var_export($suchprofilHerausgeberStandardZustaendigkeitsgebietItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The standardZustaendigkeitsgebiet property can only contain items of type \StructType\Gebiet, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set standardZustaendigkeitsgebiet value
     * @throws \InvalidArgumentException
     * @param \StructType\Gebiet[] $standardZustaendigkeitsgebiet
     * @return \StructType\SuchprofilHerausgeber
     */
    public function setStandardZustaendigkeitsgebiet(array $standardZustaendigkeitsgebiet = array())
    {
        // validation for constraint: array
        if ('' !== ($standardZustaendigkeitsgebietArrayErrorMessage = self::validateStandardZustaendigkeitsgebietForArrayConstraintsFromSetStandardZustaendigkeitsgebiet($standardZustaendigkeitsgebiet))) {
            throw new \InvalidArgumentException($standardZustaendigkeitsgebietArrayErrorMessage, __LINE__);
        }
        $this->standardZustaendigkeitsgebiet = $standardZustaendigkeitsgebiet;
        return $this;
    }
    /**
     * Add item to standardZustaendigkeitsgebiet value
     * @throws \InvalidArgumentException
     * @param \StructType\Gebiet $item
     * @return \StructType\SuchprofilHerausgeber
     */
    public function addToStandardZustaendigkeitsgebiet(\StructType\Gebiet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Gebiet) {
            throw new \InvalidArgumentException(sprintf('The standardZustaendigkeitsgebiet property can only contain items of type \StructType\Gebiet, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->standardZustaendigkeitsgebiet[] = $item;
        return $this;
    }
}
