<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuchparameterKategorie StructType
 * Meta information extracted from the WSDL
 * - documentation: Diese Klasse dient zur Übertragung von Suchparametern zur Suche nach Objekte mit bestimmten Kategorien, z.B. Leistungs- oder Organisationseinheitskategorien. Die Paramter müssen UND-verknüpft werden.
 * @subpackage Structs
 */
class SuchparameterKategorie extends AbstractStructBase
{
    /**
     * The kategorieklasseID
     * Meta information extracted from the WSDL
     * - documentation: ID der Kategorieklasse, welcher die in kategorieID angegebenen Kategorien zugeordnet sind.
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $kategorieklasseID;
    /**
     * The kategorieID
     * Meta information extracted from the WSDL
     * - documentation: ID der Kategorien, auf welche eingeschränkt wird. Es wid in primären und sekundären IDs gesucht.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $kategorieID;
    /**
     * Constructor method for SuchparameterKategorie
     * @uses SuchparameterKategorie::setKategorieklasseID()
     * @uses SuchparameterKategorie::setKategorieID()
     * @param \StructType\Identifikator $kategorieklasseID
     * @param \StructType\Identifikator[] $kategorieID
     */
    public function __construct(\StructType\Identifikator $kategorieklasseID = null, array $kategorieID = array())
    {
        $this
            ->setKategorieklasseID($kategorieklasseID)
            ->setKategorieID($kategorieID);
    }
    /**
     * Get kategorieklasseID value
     * @return \StructType\Identifikator|null
     */
    public function getKategorieklasseID()
    {
        return $this->kategorieklasseID;
    }
    /**
     * Set kategorieklasseID value
     * @param \StructType\Identifikator $kategorieklasseID
     * @return \StructType\SuchparameterKategorie
     */
    public function setKategorieklasseID(\StructType\Identifikator $kategorieklasseID = null)
    {
        $this->kategorieklasseID = $kategorieklasseID;
        return $this;
    }
    /**
     * Get kategorieID value
     * @return \StructType\Identifikator[]|null
     */
    public function getKategorieID()
    {
        return $this->kategorieID;
    }
    /**
     * This method is responsible for validating the values passed to the setKategorieID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKategorieID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKategorieIDForArrayConstraintsFromSetKategorieID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchparameterKategorieKategorieIDItem) {
            // validation for constraint: itemType
            if (!$suchparameterKategorieKategorieIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchparameterKategorieKategorieIDItem) ? get_class($suchparameterKategorieKategorieIDItem) : sprintf('%s(%s)', gettype($suchparameterKategorieKategorieIDItem), var_export($suchparameterKategorieKategorieIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kategorieID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kategorieID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $kategorieID
     * @return \StructType\SuchparameterKategorie
     */
    public function setKategorieID(array $kategorieID = array())
    {
        // validation for constraint: array
        if ('' !== ($kategorieIDArrayErrorMessage = self::validateKategorieIDForArrayConstraintsFromSetKategorieID($kategorieID))) {
            throw new \InvalidArgumentException($kategorieIDArrayErrorMessage, __LINE__);
        }
        $this->kategorieID = $kategorieID;
        return $this;
    }
    /**
     * Add item to kategorieID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchparameterKategorie
     */
    public function addToKategorieID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The kategorieID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kategorieID[] = $item;
        return $this;
    }
}
