<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for String.Localized StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp zur Abbildung mehrsprachiger Texte. Es muss hierbei ein Sprachcode angegeben werden. In bestimmten Fällen ist die Verwendung von HTML erlaubt. Dies ist an den entsprechenden Elementen vermerkt.
 * @subpackage Structs
 */
class String_Localized extends AbstractStructBase
{
    /**
     * The languageCode
     * Meta information extracted from the WSDL
     * - documentation: Code der Sprache des Texts. Abgebildet mit W3C-Datentyp language (https://www.w3.org/TR/xmlschema-2/#language). Zum Beispiel "en", "en-US", "de" oder "de-DE".
     * - use: required
     * @var string
     */
    public $languageCode;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * Constructor method for String.Localized
     * @uses String_Localized::setLanguageCode()
     * @uses String_Localized::set_()
     * @param string $languageCode
     * @param string $_
     */
    public function __construct($languageCode = null, $_ = null)
    {
        $this
            ->setLanguageCode($languageCode)
            ->set_($_);
    }
    /**
     * Get languageCode value
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }
    /**
     * Set languageCode value
     * @param string $languageCode
     * @return \StructType\String_Localized
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->languageCode = $languageCode;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\String_Localized
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
}
