<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sprache StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp zur Abbildung von Sprachen mit Code / Locale und Bezeichnungen
 * @subpackage Structs
 */
class Sprache extends AbstractStructBase
{
    /**
     * The languageCode
     * Meta information extracted from the WSDL
     * - documentation: Code der Sprache der Sprachversion. Abgebildet mit W3C-Datentyp language (https://www.w3.org/TR/xmlschema-2/#language). Zum Beispiel "en", "en-US", "de", "de-DE" oder "zh-cn".
     * @var string
     */
    public $languageCode;
    /**
     * The sprachbezeichnungDeutsch
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung der Sprach in Deutsch, z.B. "Französisch"
     * - minOccurs: 0
     * @var string
     */
    public $sprachbezeichnungDeutsch;
    /**
     * The sprachbezeichnungNativ
     * Meta information extracted from the WSDL
     * - documentation: Native Bezeichnung der Sprache, z.B. "français"
     * - minOccurs: 0
     * @var string
     */
    public $sprachbezeichnungNativ;
    /**
     * Constructor method for Sprache
     * @uses Sprache::setLanguageCode()
     * @uses Sprache::setSprachbezeichnungDeutsch()
     * @uses Sprache::setSprachbezeichnungNativ()
     * @param string $languageCode
     * @param string $sprachbezeichnungDeutsch
     * @param string $sprachbezeichnungNativ
     */
    public function __construct($languageCode = null, $sprachbezeichnungDeutsch = null, $sprachbezeichnungNativ = null)
    {
        $this
            ->setLanguageCode($languageCode)
            ->setSprachbezeichnungDeutsch($sprachbezeichnungDeutsch)
            ->setSprachbezeichnungNativ($sprachbezeichnungNativ);
    }
    /**
     * Get languageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }
    /**
     * Set languageCode value
     * @param string $languageCode
     * @return \StructType\Sprache
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->languageCode = $languageCode;
        return $this;
    }
    /**
     * Get sprachbezeichnungDeutsch value
     * @return string|null
     */
    public function getSprachbezeichnungDeutsch()
    {
        return $this->sprachbezeichnungDeutsch;
    }
    /**
     * Set sprachbezeichnungDeutsch value
     * @param string $sprachbezeichnungDeutsch
     * @return \StructType\Sprache
     */
    public function setSprachbezeichnungDeutsch($sprachbezeichnungDeutsch = null)
    {
        // validation for constraint: string
        if (!is_null($sprachbezeichnungDeutsch) && !is_string($sprachbezeichnungDeutsch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sprachbezeichnungDeutsch, true), gettype($sprachbezeichnungDeutsch)), __LINE__);
        }
        $this->sprachbezeichnungDeutsch = $sprachbezeichnungDeutsch;
        return $this;
    }
    /**
     * Get sprachbezeichnungNativ value
     * @return string|null
     */
    public function getSprachbezeichnungNativ()
    {
        return $this->sprachbezeichnungNativ;
    }
    /**
     * Set sprachbezeichnungNativ value
     * @param string $sprachbezeichnungNativ
     * @return \StructType\Sprache
     */
    public function setSprachbezeichnungNativ($sprachbezeichnungNativ = null)
    {
        // validation for constraint: string
        if (!is_null($sprachbezeichnungNativ) && !is_string($sprachbezeichnungNativ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sprachbezeichnungNativ, true), gettype($sprachbezeichnungNativ)), __LINE__);
        }
        $this->sprachbezeichnungNativ = $sprachbezeichnungNativ;
        return $this;
    }
}
