<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for simple StructType
 * @subpackage Structs
 */
class Simple extends AbstractStructBase
{
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The href
     * @var string
     */
    public $href;
    /**
     * The role
     * @var string
     */
    public $role;
    /**
     * The arcrole
     * @var string
     */
    public $arcrole;
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The show
     * @var string
     */
    public $show;
    /**
     * The actuate
     * @var string
     */
    public $actuate;
    /**
     * Constructor method for simple
     * @uses Simple::setAny()
     * @uses Simple::setType()
     * @uses Simple::setHref()
     * @uses Simple::setRole()
     * @uses Simple::setArcrole()
     * @uses Simple::setTitle()
     * @uses Simple::setShow()
     * @uses Simple::setActuate()
     * @param \DOMDocument $any
     * @param string $type
     * @param string $href
     * @param string $role
     * @param string $arcrole
     * @param string $title
     * @param string $show
     * @param string $actuate
     */
    public function __construct(\DOMDocument $any = null, $type = null, $href = null, $role = null, $arcrole = null, $title = null, $show = null, $actuate = null)
    {
        $this
            ->setAny($any)
            ->setType($type)
            ->setHref($href)
            ->setRole($role)
            ->setArcrole($arcrole)
            ->setTitle($title)
            ->setShow($show)
            ->setActuate($actuate);
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \StructType\Simple
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\Simple
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get href value
     * @return string|null
     */
    public function getHref()
    {
        return $this->href;
    }
    /**
     * Set href value
     * @param string $href
     * @return \StructType\Simple
     */
    public function setHref($href = null)
    {
        // validation for constraint: string
        if (!is_null($href) && !is_string($href)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($href, true), gettype($href)), __LINE__);
        }
        $this->href = $href;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \StructType\Simple
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Get arcrole value
     * @return string|null
     */
    public function getArcrole()
    {
        return $this->arcrole;
    }
    /**
     * Set arcrole value
     * @param string $arcrole
     * @return \StructType\Simple
     */
    public function setArcrole($arcrole = null)
    {
        // validation for constraint: string
        if (!is_null($arcrole) && !is_string($arcrole)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arcrole, true), gettype($arcrole)), __LINE__);
        }
        $this->arcrole = $arcrole;
        return $this;
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \StructType\Simple
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get show value
     * @return string|null
     */
    public function getShow()
    {
        return $this->show;
    }
    /**
     * Set show value
     * @param string $show
     * @return \StructType\Simple
     */
    public function setShow($show = null)
    {
        // validation for constraint: string
        if (!is_null($show) && !is_string($show)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($show, true), gettype($show)), __LINE__);
        }
        $this->show = $show;
        return $this;
    }
    /**
     * Get actuate value
     * @return string|null
     */
    public function getActuate()
    {
        return $this->actuate;
    }
    /**
     * Set actuate value
     * @param string $actuate
     * @return \StructType\Simple
     */
    public function setActuate($actuate = null)
    {
        // validation for constraint: string
        if (!is_null($actuate) && !is_string($actuate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actuate, true), gettype($actuate)), __LINE__);
        }
        $this->actuate = $actuate;
        return $this;
    }
}
