<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Row StructType
 * @subpackage Structs
 */
class Row extends AbstractStructBase
{
    /**
     * The posList
     * @var \StructType\DirectPositionListType
     */
    public $posList;
    /**
     * The pos
     * @var \StructType\DirectPositionType
     */
    public $pos;
    /**
     * The pointProperty
     * @var \StructType\PointPropertyType
     */
    public $pointProperty;
    /**
     * Constructor method for Row
     * @uses Row::setPosList()
     * @uses Row::setPos()
     * @uses Row::setPointProperty()
     * @param \StructType\DirectPositionListType $posList
     * @param \StructType\DirectPositionType $pos
     * @param \StructType\PointPropertyType $pointProperty
     */
    public function __construct(\StructType\DirectPositionListType $posList = null, \StructType\DirectPositionType $pos = null, \StructType\PointPropertyType $pointProperty = null)
    {
        $this
            ->setPosList($posList)
            ->setPos($pos)
            ->setPointProperty($pointProperty);
    }
    /**
     * Get posList value
     * @return \StructType\DirectPositionListType|null
     */
    public function getPosList()
    {
        return $this->posList;
    }
    /**
     * Set posList value
     * @param \StructType\DirectPositionListType $posList
     * @return \StructType\Row
     */
    public function setPosList(\StructType\DirectPositionListType $posList = null)
    {
        $this->posList = $posList;
        return $this;
    }
    /**
     * Get pos value
     * @return \StructType\DirectPositionType|null
     */
    public function getPos()
    {
        return $this->pos;
    }
    /**
     * Set pos value
     * @param \StructType\DirectPositionType $pos
     * @return \StructType\Row
     */
    public function setPos(\StructType\DirectPositionType $pos = null)
    {
        $this->pos = $pos;
        return $this;
    }
    /**
     * Get pointProperty value
     * @return \StructType\PointPropertyType|null
     */
    public function getPointProperty()
    {
        return $this->pointProperty;
    }
    /**
     * Set pointProperty value
     * @param \StructType\PointPropertyType $pointProperty
     * @return \StructType\Row
     */
    public function setPointProperty(\StructType\PointPropertyType $pointProperty = null)
    {
        $this->pointProperty = $pointProperty;
        return $this;
    }
}
