<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RingType StructType
 * @subpackage Structs
 */
class RingType extends AbstractStructBase
{
    /**
     * The curveMember
     * @var \StructType\CurvePropertyType
     */
    public $curveMember;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for RingType
     * @uses RingType::setCurveMember()
     * @uses RingType::setAggregationType()
     * @param \StructType\CurvePropertyType $curveMember
     * @param string $aggregationType
     */
    public function __construct(\StructType\CurvePropertyType $curveMember = null, $aggregationType = null)
    {
        $this
            ->setCurveMember($curveMember)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get curveMember value
     * @return \StructType\CurvePropertyType|null
     */
    public function getCurveMember()
    {
        return $this->curveMember;
    }
    /**
     * Set curveMember value
     * @param \StructType\CurvePropertyType $curveMember
     * @return \StructType\RingType
     */
    public function setCurveMember(\StructType\CurvePropertyType $curveMember = null)
    {
        $this->curveMember = $curveMember;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\RingType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
