<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecordType_PropertyType StructType
 * @subpackage Structs
 */
class RecordType_PropertyType extends AbstractStructBase
{
    /**
     * The RecordType
     * @var \StructType\RecordType_Type
     */
    public $RecordType;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for RecordType_PropertyType
     * @uses RecordType_PropertyType::setRecordType()
     * @uses RecordType_PropertyType::setNilReason()
     * @param \StructType\RecordType_Type $recordType
     * @param string $nilReason
     */
    public function __construct(\StructType\RecordType_Type $recordType = null, $nilReason = null)
    {
        $this
            ->setRecordType($recordType)
            ->setNilReason($nilReason);
    }
    /**
     * Get RecordType value
     * @return \StructType\RecordType_Type|null
     */
    public function getRecordType()
    {
        return $this->RecordType;
    }
    /**
     * Set RecordType value
     * @param \StructType\RecordType_Type $recordType
     * @return \StructType\RecordType_PropertyType
     */
    public function setRecordType(\StructType\RecordType_Type $recordType = null)
    {
        $this->RecordType = $recordType;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\RecordType_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
