<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolygonType StructType
 * @subpackage Structs
 */
class PolygonType extends AbstractStructBase
{
    /**
     * The exterior
     * @var \StructType\AbstractRingPropertyType
     */
    public $exterior;
    /**
     * The interior
     * @var \StructType\AbstractRingPropertyType
     */
    public $interior;
    /**
     * Constructor method for PolygonType
     * @uses PolygonType::setExterior()
     * @uses PolygonType::setInterior()
     * @param \StructType\AbstractRingPropertyType $exterior
     * @param \StructType\AbstractRingPropertyType $interior
     */
    public function __construct(\StructType\AbstractRingPropertyType $exterior = null, \StructType\AbstractRingPropertyType $interior = null)
    {
        $this
            ->setExterior($exterior)
            ->setInterior($interior);
    }
    /**
     * Get exterior value
     * @return \StructType\AbstractRingPropertyType|null
     */
    public function getExterior()
    {
        return $this->exterior;
    }
    /**
     * Set exterior value
     * @param \StructType\AbstractRingPropertyType $exterior
     * @return \StructType\PolygonType
     */
    public function setExterior(\StructType\AbstractRingPropertyType $exterior = null)
    {
        $this->exterior = $exterior;
        return $this;
    }
    /**
     * Get interior value
     * @return \StructType\AbstractRingPropertyType|null
     */
    public function getInterior()
    {
        return $this->interior;
    }
    /**
     * Set interior value
     * @param \StructType\AbstractRingPropertyType $interior
     * @return \StructType\PolygonType
     */
    public function setInterior(\StructType\AbstractRingPropertyType $interior = null)
    {
        $this->interior = $interior;
        return $this;
    }
}
