<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassThroughOperationType StructType
 * @subpackage Structs
 */
class PassThroughOperationType extends AbstractStructBase
{
    /**
     * The modifiedCoordinate
     * @var int
     */
    public $modifiedCoordinate;
    /**
     * The coordOperation
     * @var \StructType\CoordinateOperationPropertyType
     */
    public $coordOperation;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for PassThroughOperationType
     * @uses PassThroughOperationType::setModifiedCoordinate()
     * @uses PassThroughOperationType::setCoordOperation()
     * @uses PassThroughOperationType::setAggregationType()
     * @param int $modifiedCoordinate
     * @param \StructType\CoordinateOperationPropertyType $coordOperation
     * @param string $aggregationType
     */
    public function __construct($modifiedCoordinate = null, \StructType\CoordinateOperationPropertyType $coordOperation = null, $aggregationType = null)
    {
        $this
            ->setModifiedCoordinate($modifiedCoordinate)
            ->setCoordOperation($coordOperation)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get modifiedCoordinate value
     * @return int|null
     */
    public function getModifiedCoordinate()
    {
        return $this->modifiedCoordinate;
    }
    /**
     * Set modifiedCoordinate value
     * @param int $modifiedCoordinate
     * @return \StructType\PassThroughOperationType
     */
    public function setModifiedCoordinate($modifiedCoordinate = null)
    {
        // validation for constraint: int
        if (!is_null($modifiedCoordinate) && !(is_int($modifiedCoordinate) || ctype_digit($modifiedCoordinate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($modifiedCoordinate, true), gettype($modifiedCoordinate)), __LINE__);
        }
        $this->modifiedCoordinate = $modifiedCoordinate;
        return $this;
    }
    /**
     * Get coordOperation value
     * @return \StructType\CoordinateOperationPropertyType|null
     */
    public function getCoordOperation()
    {
        return $this->coordOperation;
    }
    /**
     * Set coordOperation value
     * @param \StructType\CoordinateOperationPropertyType $coordOperation
     * @return \StructType\PassThroughOperationType
     */
    public function setCoordOperation(\StructType\CoordinateOperationPropertyType $coordOperation = null)
    {
        $this->coordOperation = $coordOperation;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\PassThroughOperationType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
