<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParameterValueType StructType
 * @subpackage Structs
 */
class ParameterValueType extends AbstractStructBase
{
    /**
     * The value
     * @var \StructType\MeasureType
     */
    public $value;
    /**
     * The dmsAngleValue
     * @var \StructType\DMSAngleType
     */
    public $dmsAngleValue;
    /**
     * The stringValue
     * @var string
     */
    public $stringValue;
    /**
     * The integerValue
     * @var int
     */
    public $integerValue;
    /**
     * The booleanValue
     * @var bool
     */
    public $booleanValue;
    /**
     * The valueList
     * @var \StructType\MeasureListType
     */
    public $valueList;
    /**
     * The integerValueList
     * @var list
     */
    public $integerValueList;
    /**
     * The valueFile
     * @var string
     */
    public $valueFile;
    /**
     * The operationParameter
     * @var \StructType\OperationParameterPropertyType
     */
    public $operationParameter;
    /**
     * Constructor method for ParameterValueType
     * @uses ParameterValueType::setValue()
     * @uses ParameterValueType::setDmsAngleValue()
     * @uses ParameterValueType::setStringValue()
     * @uses ParameterValueType::setIntegerValue()
     * @uses ParameterValueType::setBooleanValue()
     * @uses ParameterValueType::setValueList()
     * @uses ParameterValueType::setIntegerValueList()
     * @uses ParameterValueType::setValueFile()
     * @uses ParameterValueType::setOperationParameter()
     * @param \StructType\MeasureType $value
     * @param \StructType\DMSAngleType $dmsAngleValue
     * @param string $stringValue
     * @param int $integerValue
     * @param bool $booleanValue
     * @param \StructType\MeasureListType $valueList
     * @param list $integerValueList
     * @param string $valueFile
     * @param \StructType\OperationParameterPropertyType $operationParameter
     */
    public function __construct(\StructType\MeasureType $value = null, \StructType\DMSAngleType $dmsAngleValue = null, $stringValue = null, $integerValue = null, $booleanValue = null, \StructType\MeasureListType $valueList = null, list $integerValueList = null, $valueFile = null, \StructType\OperationParameterPropertyType $operationParameter = null)
    {
        $this
            ->setValue($value)
            ->setDmsAngleValue($dmsAngleValue)
            ->setStringValue($stringValue)
            ->setIntegerValue($integerValue)
            ->setBooleanValue($booleanValue)
            ->setValueList($valueList)
            ->setIntegerValueList($integerValueList)
            ->setValueFile($valueFile)
            ->setOperationParameter($operationParameter);
    }
    /**
     * Get value value
     * @return \StructType\MeasureType|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param \StructType\MeasureType $value
     * @return \StructType\ParameterValueType
     */
    public function setValue(\StructType\MeasureType $value = null)
    {
        $this->value = $value;
        return $this;
    }
    /**
     * Get dmsAngleValue value
     * @return \StructType\DMSAngleType|null
     */
    public function getDmsAngleValue()
    {
        return $this->dmsAngleValue;
    }
    /**
     * Set dmsAngleValue value
     * @param \StructType\DMSAngleType $dmsAngleValue
     * @return \StructType\ParameterValueType
     */
    public function setDmsAngleValue(\StructType\DMSAngleType $dmsAngleValue = null)
    {
        $this->dmsAngleValue = $dmsAngleValue;
        return $this;
    }
    /**
     * Get stringValue value
     * @return string|null
     */
    public function getStringValue()
    {
        return $this->stringValue;
    }
    /**
     * Set stringValue value
     * @param string $stringValue
     * @return \StructType\ParameterValueType
     */
    public function setStringValue($stringValue = null)
    {
        // validation for constraint: string
        if (!is_null($stringValue) && !is_string($stringValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringValue, true), gettype($stringValue)), __LINE__);
        }
        $this->stringValue = $stringValue;
        return $this;
    }
    /**
     * Get integerValue value
     * @return int|null
     */
    public function getIntegerValue()
    {
        return $this->integerValue;
    }
    /**
     * Set integerValue value
     * @param int $integerValue
     * @return \StructType\ParameterValueType
     */
    public function setIntegerValue($integerValue = null)
    {
        // validation for constraint: int
        if (!is_null($integerValue) && !(is_int($integerValue) || ctype_digit($integerValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($integerValue, true), gettype($integerValue)), __LINE__);
        }
        $this->integerValue = $integerValue;
        return $this;
    }
    /**
     * Get booleanValue value
     * @return bool|null
     */
    public function getBooleanValue()
    {
        return $this->booleanValue;
    }
    /**
     * Set booleanValue value
     * @param bool $booleanValue
     * @return \StructType\ParameterValueType
     */
    public function setBooleanValue($booleanValue = null)
    {
        // validation for constraint: boolean
        if (!is_null($booleanValue) && !is_bool($booleanValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($booleanValue, true), gettype($booleanValue)), __LINE__);
        }
        $this->booleanValue = $booleanValue;
        return $this;
    }
    /**
     * Get valueList value
     * @return \StructType\MeasureListType|null
     */
    public function getValueList()
    {
        return $this->valueList;
    }
    /**
     * Set valueList value
     * @param \StructType\MeasureListType $valueList
     * @return \StructType\ParameterValueType
     */
    public function setValueList(\StructType\MeasureListType $valueList = null)
    {
        $this->valueList = $valueList;
        return $this;
    }
    /**
     * Get integerValueList value
     * @return list|null
     */
    public function getIntegerValueList()
    {
        return $this->integerValueList;
    }
    /**
     * Set integerValueList value
     * @param list $integerValueList
     * @return \StructType\ParameterValueType
     */
    public function setIntegerValueList(list $integerValueList = null)
    {
        $this->integerValueList = $integerValueList;
        return $this;
    }
    /**
     * Get valueFile value
     * @return string|null
     */
    public function getValueFile()
    {
        return $this->valueFile;
    }
    /**
     * Set valueFile value
     * @param string $valueFile
     * @return \StructType\ParameterValueType
     */
    public function setValueFile($valueFile = null)
    {
        // validation for constraint: string
        if (!is_null($valueFile) && !is_string($valueFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueFile, true), gettype($valueFile)), __LINE__);
        }
        $this->valueFile = $valueFile;
        return $this;
    }
    /**
     * Get operationParameter value
     * @return \StructType\OperationParameterPropertyType|null
     */
    public function getOperationParameter()
    {
        return $this->operationParameter;
    }
    /**
     * Set operationParameter value
     * @param \StructType\OperationParameterPropertyType $operationParameter
     * @return \StructType\ParameterValueType
     */
    public function setOperationParameter(\StructType\OperationParameterPropertyType $operationParameter = null)
    {
        $this->operationParameter = $operationParameter;
        return $this;
    }
}
