<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrientableSurfaceType StructType
 * @subpackage Structs
 */
class OrientableSurfaceType extends AbstractStructBase
{
    /**
     * The baseSurface
     * @var \StructType\SurfacePropertyType
     */
    public $baseSurface;
    /**
     * The orientation
     * @var string
     */
    public $orientation;
    /**
     * Constructor method for OrientableSurfaceType
     * @uses OrientableSurfaceType::setBaseSurface()
     * @uses OrientableSurfaceType::setOrientation()
     * @param \StructType\SurfacePropertyType $baseSurface
     * @param string $orientation
     */
    public function __construct(\StructType\SurfacePropertyType $baseSurface = null, $orientation = null)
    {
        $this
            ->setBaseSurface($baseSurface)
            ->setOrientation($orientation);
    }
    /**
     * Get baseSurface value
     * @return \StructType\SurfacePropertyType|null
     */
    public function getBaseSurface()
    {
        return $this->baseSurface;
    }
    /**
     * Set baseSurface value
     * @param \StructType\SurfacePropertyType $baseSurface
     * @return \StructType\OrientableSurfaceType
     */
    public function setBaseSurface(\StructType\SurfacePropertyType $baseSurface = null)
    {
        $this->baseSurface = $baseSurface;
        return $this;
    }
    /**
     * Get orientation value
     * @return string|null
     */
    public function getOrientation()
    {
        return $this->orientation;
    }
    /**
     * Set orientation value
     * @param string $orientation
     * @return \StructType\OrientableSurfaceType
     */
    public function setOrientation($orientation = null)
    {
        // validation for constraint: string
        if (!is_null($orientation) && !is_string($orientation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orientation, true), gettype($orientation)), __LINE__);
        }
        $this->orientation = $orientation;
        return $this;
    }
}
