<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationParameterGroupType StructType
 * @subpackage Structs
 */
class OperationParameterGroupType extends AbstractStructBase
{
    /**
     * The maximumOccurs
     * @var int
     */
    public $maximumOccurs;
    /**
     * The parameter
     * @var \StructType\AbstractGeneralOperationParameterPropertyType
     */
    public $parameter;
    /**
     * Constructor method for OperationParameterGroupType
     * @uses OperationParameterGroupType::setMaximumOccurs()
     * @uses OperationParameterGroupType::setParameter()
     * @param int $maximumOccurs
     * @param \StructType\AbstractGeneralOperationParameterPropertyType $parameter
     */
    public function __construct($maximumOccurs = null, \StructType\AbstractGeneralOperationParameterPropertyType $parameter = null)
    {
        $this
            ->setMaximumOccurs($maximumOccurs)
            ->setParameter($parameter);
    }
    /**
     * Get maximumOccurs value
     * @return int|null
     */
    public function getMaximumOccurs()
    {
        return $this->maximumOccurs;
    }
    /**
     * Set maximumOccurs value
     * @param int $maximumOccurs
     * @return \StructType\OperationParameterGroupType
     */
    public function setMaximumOccurs($maximumOccurs = null)
    {
        // validation for constraint: int
        if (!is_null($maximumOccurs) && !(is_int($maximumOccurs) || ctype_digit($maximumOccurs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumOccurs, true), gettype($maximumOccurs)), __LINE__);
        }
        $this->maximumOccurs = $maximumOccurs;
        return $this;
    }
    /**
     * Get parameter value
     * @return \StructType\AbstractGeneralOperationParameterPropertyType|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @param \StructType\AbstractGeneralOperationParameterPropertyType $parameter
     * @return \StructType\OperationParameterGroupType
     */
    public function setParameter(\StructType\AbstractGeneralOperationParameterPropertyType $parameter = null)
    {
        $this->parameter = $parameter;
        return $this;
    }
}
