<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnlinedienstParameter StructType
 * Meta information extracted from the WSDL
 * - documentation: Statische Parameter zur Konfiguration des Onlinedienstes. Die Parameter sind Key/Value-Paare.
 * @subpackage Structs
 */
class OnlinedienstParameter extends AbstractStructBase
{
    /**
     * The parameterName
     * Meta information extracted from the WSDL
     * - documentation: Name des Parameters (Key).
     * @var string
     */
    public $parameterName;
    /**
     * The parameterWert
     * Meta information extracted from the WSDL
     * - documentation: Wert des Parameters (Value).
     * - minOccurs: 0
     * @var string
     */
    public $parameterWert;
    /**
     * Constructor method for OnlinedienstParameter
     * @uses OnlinedienstParameter::setParameterName()
     * @uses OnlinedienstParameter::setParameterWert()
     * @param string $parameterName
     * @param string $parameterWert
     */
    public function __construct($parameterName = null, $parameterWert = null)
    {
        $this
            ->setParameterName($parameterName)
            ->setParameterWert($parameterWert);
    }
    /**
     * Get parameterName value
     * @return string|null
     */
    public function getParameterName()
    {
        return $this->parameterName;
    }
    /**
     * Set parameterName value
     * @param string $parameterName
     * @return \StructType\OnlinedienstParameter
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameterName, true), gettype($parameterName)), __LINE__);
        }
        $this->parameterName = $parameterName;
        return $this;
    }
    /**
     * Get parameterWert value
     * @return string|null
     */
    public function getParameterWert()
    {
        return $this->parameterWert;
    }
    /**
     * Set parameterWert value
     * @param string $parameterWert
     * @return \StructType\OnlinedienstParameter
     */
    public function setParameterWert($parameterWert = null)
    {
        // validation for constraint: string
        if (!is_null($parameterWert) && !is_string($parameterWert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameterWert, true), gettype($parameterWert)), __LINE__);
        }
        $this->parameterWert = $parameterWert;
        return $this;
    }
}
