<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnlinedienstLink StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp zur Abbildung von Links zu Onlinediensten.
 * @subpackage Structs
 */
class OnlinedienstLink extends AbstractStructBase
{
    /**
     * The typ
     * Meta information extracted from the WSDL
     * - documentation: Typ/Kanal des Links.
     * @var \StructType\Code_OnlinedienstLinkTyp
     */
    public $typ;
    /**
     * The link
     * Meta information extracted from the WSDL
     * - documentation: URL zum Onlinedienst inklusive der URL-Parameter. Vorhandene dynamische Parameter müssen zusätzlich angehangen werden.
     * @var string
     */
    public $link;
    /**
     * The dynamischeParameter
     * Meta information extracted from the WSDL
     * - documentation: Parameter, welche während des Renderns der Links je nach Kontext dynamisch belegt werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OnlinedienstDynamischerParameter[]
     */
    public $dynamischeParameter;
    /**
     * The titel
     * Meta information extracted from the WSDL
     * - documentation: Titel der URI
     * - minOccurs: 0
     * @var string
     */
    public $titel;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der URI, z.B. kurze Hinweise zur Zielseite
     * - minOccurs: 0
     * @var string
     */
    public $beschreibung;
    /**
     * The positionDarstellung
     * Meta information extracted from the WSDL
     * - documentation: Position in der gesamten Darstellung der Links.
     * - minOccurs: 0
     * @var int
     */
    public $positionDarstellung;
    /**
     * The languageCode
     * Meta information extracted from the WSDL
     * - documentation: Code der Sprache des Texts. Abgebildet mit W3C-Datentyp xs:language (http://www.w3.org/TR/xmlschema-2/#language)
     * - use: optional
     * @var string
     */
    public $languageCode;
    /**
     * Constructor method for OnlinedienstLink
     * @uses OnlinedienstLink::setTyp()
     * @uses OnlinedienstLink::setLink()
     * @uses OnlinedienstLink::setDynamischeParameter()
     * @uses OnlinedienstLink::setTitel()
     * @uses OnlinedienstLink::setBeschreibung()
     * @uses OnlinedienstLink::setPositionDarstellung()
     * @uses OnlinedienstLink::setLanguageCode()
     * @param \StructType\Code_OnlinedienstLinkTyp $typ
     * @param string $link
     * @param \StructType\OnlinedienstDynamischerParameter[] $dynamischeParameter
     * @param string $titel
     * @param string $beschreibung
     * @param int $positionDarstellung
     * @param string $languageCode
     */
    public function __construct(\StructType\Code_OnlinedienstLinkTyp $typ = null, $link = null, array $dynamischeParameter = array(), $titel = null, $beschreibung = null, $positionDarstellung = null, $languageCode = null)
    {
        $this
            ->setTyp($typ)
            ->setLink($link)
            ->setDynamischeParameter($dynamischeParameter)
            ->setTitel($titel)
            ->setBeschreibung($beschreibung)
            ->setPositionDarstellung($positionDarstellung)
            ->setLanguageCode($languageCode);
    }
    /**
     * Get typ value
     * @return \StructType\Code_OnlinedienstLinkTyp|null
     */
    public function getTyp()
    {
        return $this->typ;
    }
    /**
     * Set typ value
     * @param \StructType\Code_OnlinedienstLinkTyp $typ
     * @return \StructType\OnlinedienstLink
     */
    public function setTyp(\StructType\Code_OnlinedienstLinkTyp $typ = null)
    {
        $this->typ = $typ;
        return $this;
    }
    /**
     * Get link value
     * @return string|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @param string $link
     * @return \StructType\OnlinedienstLink
     */
    public function setLink($link = null)
    {
        // validation for constraint: string
        if (!is_null($link) && !is_string($link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($link, true), gettype($link)), __LINE__);
        }
        $this->link = $link;
        return $this;
    }
    /**
     * Get dynamischeParameter value
     * @return \StructType\OnlinedienstDynamischerParameter[]|null
     */
    public function getDynamischeParameter()
    {
        return $this->dynamischeParameter;
    }
    /**
     * This method is responsible for validating the values passed to the setDynamischeParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDynamischeParameter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDynamischeParameterForArrayConstraintsFromSetDynamischeParameter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstLinkDynamischeParameterItem) {
            // validation for constraint: itemType
            if (!$onlinedienstLinkDynamischeParameterItem instanceof \StructType\OnlinedienstDynamischerParameter) {
                $invalidValues[] = is_object($onlinedienstLinkDynamischeParameterItem) ? get_class($onlinedienstLinkDynamischeParameterItem) : sprintf('%s(%s)', gettype($onlinedienstLinkDynamischeParameterItem), var_export($onlinedienstLinkDynamischeParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dynamischeParameter property can only contain items of type \StructType\OnlinedienstDynamischerParameter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dynamischeParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\OnlinedienstDynamischerParameter[] $dynamischeParameter
     * @return \StructType\OnlinedienstLink
     */
    public function setDynamischeParameter(array $dynamischeParameter = array())
    {
        // validation for constraint: array
        if ('' !== ($dynamischeParameterArrayErrorMessage = self::validateDynamischeParameterForArrayConstraintsFromSetDynamischeParameter($dynamischeParameter))) {
            throw new \InvalidArgumentException($dynamischeParameterArrayErrorMessage, __LINE__);
        }
        $this->dynamischeParameter = $dynamischeParameter;
        return $this;
    }
    /**
     * Add item to dynamischeParameter value
     * @throws \InvalidArgumentException
     * @param \StructType\OnlinedienstDynamischerParameter $item
     * @return \StructType\OnlinedienstLink
     */
    public function addToDynamischeParameter(\StructType\OnlinedienstDynamischerParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OnlinedienstDynamischerParameter) {
            throw new \InvalidArgumentException(sprintf('The dynamischeParameter property can only contain items of type \StructType\OnlinedienstDynamischerParameter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dynamischeParameter[] = $item;
        return $this;
    }
    /**
     * Get titel value
     * @return string|null
     */
    public function getTitel()
    {
        return $this->titel;
    }
    /**
     * Set titel value
     * @param string $titel
     * @return \StructType\OnlinedienstLink
     */
    public function setTitel($titel = null)
    {
        // validation for constraint: string
        if (!is_null($titel) && !is_string($titel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titel, true), gettype($titel)), __LINE__);
        }
        $this->titel = $titel;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * Set beschreibung value
     * @param string $beschreibung
     * @return \StructType\OnlinedienstLink
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Get positionDarstellung value
     * @return int|null
     */
    public function getPositionDarstellung()
    {
        return $this->positionDarstellung;
    }
    /**
     * Set positionDarstellung value
     * @param int $positionDarstellung
     * @return \StructType\OnlinedienstLink
     */
    public function setPositionDarstellung($positionDarstellung = null)
    {
        // validation for constraint: int
        if (!is_null($positionDarstellung) && !(is_int($positionDarstellung) || ctype_digit($positionDarstellung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($positionDarstellung, true), gettype($positionDarstellung)), __LINE__);
        }
        $this->positionDarstellung = $positionDarstellung;
        return $this;
    }
    /**
     * Get languageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }
    /**
     * Set languageCode value
     * @param string $languageCode
     * @return \StructType\OnlinedienstLink
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->languageCode = $languageCode;
        return $this;
    }
}
