<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Onlinedienst StructType
 * Meta information extracted from the WSDL
 * - documentation: Im Internet verfügbarer Dienst zur elektronischen Inanspruchnahme von Verwaltungsleistungen.
 * @subpackage Structs
 */
class Onlinedienst extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Primäre ID
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * Meta information extracted from the WSDL
     * - documentation: Sekundäre IDs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idSekundaer;
    /**
     * The bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung des Onlinedienstes.
     * - maxOccurs: unbounded
     * @var \StructType\String_Localized[]
     */
    public $bezeichnung;
    /**
     * The kurzbezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Kurze Bezeichnung des Onlinediesntes, z.B. eine Abkürzung.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $kurzbezeichnung;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Allgemeine Beschreibung des Onlinedienstes.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The teaser
     * Meta information extracted from the WSDL
     * - documentation: Teaser-Text des Onlinedienstes, um ihn z.B. in Suchergebnislisten kurz zu erläutern.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $teaser;
    /**
     * The link
     * Meta information extracted from the WSDL
     * - documentation: URL zum Onlinedienst inklusiver aller Parameter. Vorhandene dynamische Parameter müssen zusätzlich angehangen werden.
     * - maxOccurs: unbounded
     * @var \StructType\OnlinedienstLink[]
     */
    public $link;
    /**
     * The parameter
     * Meta information extracted from the WSDL
     * - documentation: Parameter zur Konfiguration des Dienstes. Achtung: Diese Parameter sind nicht noch einmal zusätzlich an die URLs zu den Diensten anzuhängen. Dieses Element kann übermittelt werden, falls eine separate Betrachtung von Parametern im
     * Anwendungsfall wichtig ist.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OnlinedienstParameter[]
     */
    public $parameter;
    /**
     * The durchfuehrungStaatsangehoerigkeit
     * Meta information extracted from the WSDL
     * - documentation: Angabe der zur Inanspruchnahme des Dienstes möglichen Staatsangehörigkeiten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_StaatsangehoerigkeitDestatis[]
     */
    public $durchfuehrungStaatsangehoerigkeit;
    /**
     * The durchfuehrungSprachen
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Sprachen, in welchen der Onlinedienst durchgeführt bzw. in Anspruch genommen werden kann.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Sprache[]
     */
    public $durchfuehrungSprachen;
    /**
     * The zahlungsweise
     * Meta information extracted from the WSDL
     * - documentation: Verfügbare Zahlungsweisen für den Onlinedienst.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_Zahlungsweise[]
     */
    public $zahlungsweise;
    /**
     * The vertrauensniveau
     * Meta information extracted from the WSDL
     * - documentation: Angabe des Vertrauensniveaus (Level of Assurance).
     * @var \StructType\Code_Vertrauensniveau
     */
    public $vertrauensniveau;
    /**
     * The identifizierungsmittel
     * Meta information extracted from the WSDL
     * - documentation: Angabe der zulässigen Identifizierungsmittel für den Online-Dienst.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_Identifizierungsmittel[]
     */
    public $identifizierungsmittel;
    /**
     * The logo
     * Meta information extracted from the WSDL
     * - documentation: Logo des Onlinedienstes als Referenz. Die Logo-Datei kann mittels der Nachricht allgemein.anfrage|antwort.datei abgefragt bzw. übermittelt werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $logo;
    /**
     * The hilfeLink
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Links zu Hilfe-Ressourcen zum Onlinedienst.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HyperlinkErweitert[]
     */
    public $hilfeLink;
    /**
     * The hilfeText
     * Meta information extracted from the WSDL
     * - documentation: Kurze Beschreibung zu Hilfe-Ressourcen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $hilfeText;
    /**
     * The herausgeber
     * Meta information extracted from the WSDL
     * - documentation: Optionale Angabe des Herausgebers der Daten.
     * - minOccurs: 0
     * @var \StructType\Herausgeber
     */
    public $herausgeber;
    /**
     * The versionsinformation
     * Meta information extracted from the WSDL
     * - documentation: Informationen zur Versionierung.
     * - minOccurs: 0
     * @var \StructType\Versionsinformation
     */
    public $versionsinformation;
    /**
     * The sprachversion
     * Meta information extracted from the WSDL
     * - documentation: Angabe aller verfügbaren Sprachversionen des Objekts. Achtung: Dies betrifft nur die Metadaten der aktuellen Klasse und ist nicht zu verwechseln, in welchen Sprachen der Onlinedienst abgewickelt werden kann.
     * - maxOccurs: unbounded
     * @var \StructType\Sprachversion[]
     */
    public $sprachversion;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for Onlinedienst
     * @uses Onlinedienst::setId()
     * @uses Onlinedienst::setIdSekundaer()
     * @uses Onlinedienst::setBezeichnung()
     * @uses Onlinedienst::setKurzbezeichnung()
     * @uses Onlinedienst::setBeschreibung()
     * @uses Onlinedienst::setTeaser()
     * @uses Onlinedienst::setLink()
     * @uses Onlinedienst::setParameter()
     * @uses Onlinedienst::setDurchfuehrungStaatsangehoerigkeit()
     * @uses Onlinedienst::setDurchfuehrungSprachen()
     * @uses Onlinedienst::setZahlungsweise()
     * @uses Onlinedienst::setVertrauensniveau()
     * @uses Onlinedienst::setIdentifizierungsmittel()
     * @uses Onlinedienst::setLogo()
     * @uses Onlinedienst::setHilfeLink()
     * @uses Onlinedienst::setHilfeText()
     * @uses Onlinedienst::setHerausgeber()
     * @uses Onlinedienst::setVersionsinformation()
     * @uses Onlinedienst::setSprachversion()
     * @uses Onlinedienst::setGueltigkeit()
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator[] $idSekundaer
     * @param \StructType\String_Localized[] $bezeichnung
     * @param \StructType\String_Localized[] $kurzbezeichnung
     * @param \StructType\String_Localized[] $beschreibung
     * @param \StructType\String_Localized[] $teaser
     * @param \StructType\OnlinedienstLink[] $link
     * @param \StructType\OnlinedienstParameter[] $parameter
     * @param \StructType\Code_StaatsangehoerigkeitDestatis[] $durchfuehrungStaatsangehoerigkeit
     * @param \StructType\Sprache[] $durchfuehrungSprachen
     * @param \StructType\Code_Zahlungsweise[] $zahlungsweise
     * @param \StructType\Code_Vertrauensniveau $vertrauensniveau
     * @param \StructType\Code_Identifizierungsmittel[] $identifizierungsmittel
     * @param \StructType\Identifikator[] $logo
     * @param \StructType\HyperlinkErweitert[] $hilfeLink
     * @param \StructType\String_Localized[] $hilfeText
     * @param \StructType\Herausgeber $herausgeber
     * @param \StructType\Versionsinformation $versionsinformation
     * @param \StructType\Sprachversion[] $sprachversion
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(\StructType\Identifikator $id = null, array $idSekundaer = array(), array $bezeichnung = array(), array $kurzbezeichnung = array(), array $beschreibung = array(), array $teaser = array(), array $link = array(), array $parameter = array(), array $durchfuehrungStaatsangehoerigkeit = array(), array $durchfuehrungSprachen = array(), array $zahlungsweise = array(), \StructType\Code_Vertrauensniveau $vertrauensniveau = null, array $identifizierungsmittel = array(), array $logo = array(), array $hilfeLink = array(), array $hilfeText = array(), \StructType\Herausgeber $herausgeber = null, \StructType\Versionsinformation $versionsinformation = null, array $sprachversion = array(), array $gueltigkeit = array())
    {
        $this
            ->setId($id)
            ->setIdSekundaer($idSekundaer)
            ->setBezeichnung($bezeichnung)
            ->setKurzbezeichnung($kurzbezeichnung)
            ->setBeschreibung($beschreibung)
            ->setTeaser($teaser)
            ->setLink($link)
            ->setParameter($parameter)
            ->setDurchfuehrungStaatsangehoerigkeit($durchfuehrungStaatsangehoerigkeit)
            ->setDurchfuehrungSprachen($durchfuehrungSprachen)
            ->setZahlungsweise($zahlungsweise)
            ->setVertrauensniveau($vertrauensniveau)
            ->setIdentifizierungsmittel($identifizierungsmittel)
            ->setLogo($logo)
            ->setHilfeLink($hilfeLink)
            ->setHilfeText($hilfeText)
            ->setHerausgeber($herausgeber)
            ->setVersionsinformation($versionsinformation)
            ->setSprachversion($sprachversion)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Onlinedienst
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSekundaer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSekundaer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSekundaerForArrayConstraintsFromSetIdSekundaer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstIdSekundaerItem) {
            // validation for constraint: itemType
            if (!$onlinedienstIdSekundaerItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($onlinedienstIdSekundaerItem) ? get_class($onlinedienstIdSekundaerItem) : sprintf('%s(%s)', gettype($onlinedienstIdSekundaerItem), var_export($onlinedienstIdSekundaerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idSekundaer
     * @return \StructType\Onlinedienst
     */
    public function setIdSekundaer(array $idSekundaer = array())
    {
        // validation for constraint: array
        if ('' !== ($idSekundaerArrayErrorMessage = self::validateIdSekundaerForArrayConstraintsFromSetIdSekundaer($idSekundaer))) {
            throw new \InvalidArgumentException($idSekundaerArrayErrorMessage, __LINE__);
        }
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Add item to idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Onlinedienst
     */
    public function addToIdSekundaer(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSekundaer[] = $item;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setBezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBezeichnungForArrayConstraintsFromSetBezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstBezeichnungItem) {
            // validation for constraint: itemType
            if (!$onlinedienstBezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($onlinedienstBezeichnungItem) ? get_class($onlinedienstBezeichnungItem) : sprintf('%s(%s)', gettype($onlinedienstBezeichnungItem), var_export($onlinedienstBezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $bezeichnung
     * @return \StructType\Onlinedienst
     */
    public function setBezeichnung(array $bezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($bezeichnungArrayErrorMessage = self::validateBezeichnungForArrayConstraintsFromSetBezeichnung($bezeichnung))) {
            throw new \InvalidArgumentException($bezeichnungArrayErrorMessage, __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Add item to bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Onlinedienst
     */
    public function addToBezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bezeichnung[] = $item;
        return $this;
    }
    /**
     * Get kurzbezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getKurzbezeichnung()
    {
        return $this->kurzbezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setKurzbezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKurzbezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstKurzbezeichnungItem) {
            // validation for constraint: itemType
            if (!$onlinedienstKurzbezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($onlinedienstKurzbezeichnungItem) ? get_class($onlinedienstKurzbezeichnungItem) : sprintf('%s(%s)', gettype($onlinedienstKurzbezeichnungItem), var_export($onlinedienstKurzbezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kurzbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $kurzbezeichnung
     * @return \StructType\Onlinedienst
     */
    public function setKurzbezeichnung(array $kurzbezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($kurzbezeichnungArrayErrorMessage = self::validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung($kurzbezeichnung))) {
            throw new \InvalidArgumentException($kurzbezeichnungArrayErrorMessage, __LINE__);
        }
        $this->kurzbezeichnung = $kurzbezeichnung;
        return $this;
    }
    /**
     * Add item to kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Onlinedienst
     */
    public function addToKurzbezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The kurzbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kurzbezeichnung[] = $item;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstBeschreibungItem) {
            // validation for constraint: itemType
            if (!$onlinedienstBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($onlinedienstBeschreibungItem) ? get_class($onlinedienstBeschreibungItem) : sprintf('%s(%s)', gettype($onlinedienstBeschreibungItem), var_export($onlinedienstBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Onlinedienst
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Onlinedienst
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get teaser value
     * @return \StructType\String_Localized[]|null
     */
    public function getTeaser()
    {
        return $this->teaser;
    }
    /**
     * This method is responsible for validating the values passed to the setTeaser method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTeaser method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTeaserForArrayConstraintsFromSetTeaser(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstTeaserItem) {
            // validation for constraint: itemType
            if (!$onlinedienstTeaserItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($onlinedienstTeaserItem) ? get_class($onlinedienstTeaserItem) : sprintf('%s(%s)', gettype($onlinedienstTeaserItem), var_export($onlinedienstTeaserItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The teaser property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set teaser value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $teaser
     * @return \StructType\Onlinedienst
     */
    public function setTeaser(array $teaser = array())
    {
        // validation for constraint: array
        if ('' !== ($teaserArrayErrorMessage = self::validateTeaserForArrayConstraintsFromSetTeaser($teaser))) {
            throw new \InvalidArgumentException($teaserArrayErrorMessage, __LINE__);
        }
        $this->teaser = $teaser;
        return $this;
    }
    /**
     * Add item to teaser value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Onlinedienst
     */
    public function addToTeaser(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The teaser property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->teaser[] = $item;
        return $this;
    }
    /**
     * Get link value
     * @return \StructType\OnlinedienstLink[]|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * This method is responsible for validating the values passed to the setLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLinkForArrayConstraintsFromSetLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstLinkItem) {
            // validation for constraint: itemType
            if (!$onlinedienstLinkItem instanceof \StructType\OnlinedienstLink) {
                $invalidValues[] = is_object($onlinedienstLinkItem) ? get_class($onlinedienstLinkItem) : sprintf('%s(%s)', gettype($onlinedienstLinkItem), var_export($onlinedienstLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The link property can only contain items of type \StructType\OnlinedienstLink, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set link value
     * @throws \InvalidArgumentException
     * @param \StructType\OnlinedienstLink[] $link
     * @return \StructType\Onlinedienst
     */
    public function setLink(array $link = array())
    {
        // validation for constraint: array
        if ('' !== ($linkArrayErrorMessage = self::validateLinkForArrayConstraintsFromSetLink($link))) {
            throw new \InvalidArgumentException($linkArrayErrorMessage, __LINE__);
        }
        $this->link = $link;
        return $this;
    }
    /**
     * Add item to link value
     * @throws \InvalidArgumentException
     * @param \StructType\OnlinedienstLink $item
     * @return \StructType\Onlinedienst
     */
    public function addToLink(\StructType\OnlinedienstLink $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OnlinedienstLink) {
            throw new \InvalidArgumentException(sprintf('The link property can only contain items of type \StructType\OnlinedienstLink, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->link[] = $item;
        return $this;
    }
    /**
     * Get parameter value
     * @return \StructType\OnlinedienstParameter[]|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * This method is responsible for validating the values passed to the setParameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setParameter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateParameterForArrayConstraintsFromSetParameter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstParameterItem) {
            // validation for constraint: itemType
            if (!$onlinedienstParameterItem instanceof \StructType\OnlinedienstParameter) {
                $invalidValues[] = is_object($onlinedienstParameterItem) ? get_class($onlinedienstParameterItem) : sprintf('%s(%s)', gettype($onlinedienstParameterItem), var_export($onlinedienstParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The parameter property can only contain items of type \StructType\OnlinedienstParameter, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set parameter value
     * @throws \InvalidArgumentException
     * @param \StructType\OnlinedienstParameter[] $parameter
     * @return \StructType\Onlinedienst
     */
    public function setParameter(array $parameter = array())
    {
        // validation for constraint: array
        if ('' !== ($parameterArrayErrorMessage = self::validateParameterForArrayConstraintsFromSetParameter($parameter))) {
            throw new \InvalidArgumentException($parameterArrayErrorMessage, __LINE__);
        }
        $this->parameter = $parameter;
        return $this;
    }
    /**
     * Add item to parameter value
     * @throws \InvalidArgumentException
     * @param \StructType\OnlinedienstParameter $item
     * @return \StructType\Onlinedienst
     */
    public function addToParameter(\StructType\OnlinedienstParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OnlinedienstParameter) {
            throw new \InvalidArgumentException(sprintf('The parameter property can only contain items of type \StructType\OnlinedienstParameter, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->parameter[] = $item;
        return $this;
    }
    /**
     * Get durchfuehrungStaatsangehoerigkeit value
     * @return \StructType\Code_StaatsangehoerigkeitDestatis[]|null
     */
    public function getDurchfuehrungStaatsangehoerigkeit()
    {
        return $this->durchfuehrungStaatsangehoerigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setDurchfuehrungStaatsangehoerigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDurchfuehrungStaatsangehoerigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurchfuehrungStaatsangehoerigkeitForArrayConstraintsFromSetDurchfuehrungStaatsangehoerigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstDurchfuehrungStaatsangehoerigkeitItem) {
            // validation for constraint: itemType
            if (!$onlinedienstDurchfuehrungStaatsangehoerigkeitItem instanceof \StructType\Code_StaatsangehoerigkeitDestatis) {
                $invalidValues[] = is_object($onlinedienstDurchfuehrungStaatsangehoerigkeitItem) ? get_class($onlinedienstDurchfuehrungStaatsangehoerigkeitItem) : sprintf('%s(%s)', gettype($onlinedienstDurchfuehrungStaatsangehoerigkeitItem), var_export($onlinedienstDurchfuehrungStaatsangehoerigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The durchfuehrungStaatsangehoerigkeit property can only contain items of type \StructType\Code_StaatsangehoerigkeitDestatis, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set durchfuehrungStaatsangehoerigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_StaatsangehoerigkeitDestatis[] $durchfuehrungStaatsangehoerigkeit
     * @return \StructType\Onlinedienst
     */
    public function setDurchfuehrungStaatsangehoerigkeit(array $durchfuehrungStaatsangehoerigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($durchfuehrungStaatsangehoerigkeitArrayErrorMessage = self::validateDurchfuehrungStaatsangehoerigkeitForArrayConstraintsFromSetDurchfuehrungStaatsangehoerigkeit($durchfuehrungStaatsangehoerigkeit))) {
            throw new \InvalidArgumentException($durchfuehrungStaatsangehoerigkeitArrayErrorMessage, __LINE__);
        }
        $this->durchfuehrungStaatsangehoerigkeit = $durchfuehrungStaatsangehoerigkeit;
        return $this;
    }
    /**
     * Add item to durchfuehrungStaatsangehoerigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_StaatsangehoerigkeitDestatis $item
     * @return \StructType\Onlinedienst
     */
    public function addToDurchfuehrungStaatsangehoerigkeit(\StructType\Code_StaatsangehoerigkeitDestatis $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_StaatsangehoerigkeitDestatis) {
            throw new \InvalidArgumentException(sprintf('The durchfuehrungStaatsangehoerigkeit property can only contain items of type \StructType\Code_StaatsangehoerigkeitDestatis, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->durchfuehrungStaatsangehoerigkeit[] = $item;
        return $this;
    }
    /**
     * Get durchfuehrungSprachen value
     * @return \StructType\Sprache[]|null
     */
    public function getDurchfuehrungSprachen()
    {
        return $this->durchfuehrungSprachen;
    }
    /**
     * This method is responsible for validating the values passed to the setDurchfuehrungSprachen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDurchfuehrungSprachen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDurchfuehrungSprachenForArrayConstraintsFromSetDurchfuehrungSprachen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstDurchfuehrungSprachenItem) {
            // validation for constraint: itemType
            if (!$onlinedienstDurchfuehrungSprachenItem instanceof \StructType\Sprache) {
                $invalidValues[] = is_object($onlinedienstDurchfuehrungSprachenItem) ? get_class($onlinedienstDurchfuehrungSprachenItem) : sprintf('%s(%s)', gettype($onlinedienstDurchfuehrungSprachenItem), var_export($onlinedienstDurchfuehrungSprachenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The durchfuehrungSprachen property can only contain items of type \StructType\Sprache, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set durchfuehrungSprachen value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprache[] $durchfuehrungSprachen
     * @return \StructType\Onlinedienst
     */
    public function setDurchfuehrungSprachen(array $durchfuehrungSprachen = array())
    {
        // validation for constraint: array
        if ('' !== ($durchfuehrungSprachenArrayErrorMessage = self::validateDurchfuehrungSprachenForArrayConstraintsFromSetDurchfuehrungSprachen($durchfuehrungSprachen))) {
            throw new \InvalidArgumentException($durchfuehrungSprachenArrayErrorMessage, __LINE__);
        }
        $this->durchfuehrungSprachen = $durchfuehrungSprachen;
        return $this;
    }
    /**
     * Add item to durchfuehrungSprachen value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprache $item
     * @return \StructType\Onlinedienst
     */
    public function addToDurchfuehrungSprachen(\StructType\Sprache $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sprache) {
            throw new \InvalidArgumentException(sprintf('The durchfuehrungSprachen property can only contain items of type \StructType\Sprache, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->durchfuehrungSprachen[] = $item;
        return $this;
    }
    /**
     * Get zahlungsweise value
     * @return \StructType\Code_Zahlungsweise[]|null
     */
    public function getZahlungsweise()
    {
        return $this->zahlungsweise;
    }
    /**
     * This method is responsible for validating the values passed to the setZahlungsweise method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZahlungsweise method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZahlungsweiseForArrayConstraintsFromSetZahlungsweise(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstZahlungsweiseItem) {
            // validation for constraint: itemType
            if (!$onlinedienstZahlungsweiseItem instanceof \StructType\Code_Zahlungsweise) {
                $invalidValues[] = is_object($onlinedienstZahlungsweiseItem) ? get_class($onlinedienstZahlungsweiseItem) : sprintf('%s(%s)', gettype($onlinedienstZahlungsweiseItem), var_export($onlinedienstZahlungsweiseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zahlungsweise property can only contain items of type \StructType\Code_Zahlungsweise, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zahlungsweise value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Zahlungsweise[] $zahlungsweise
     * @return \StructType\Onlinedienst
     */
    public function setZahlungsweise(array $zahlungsweise = array())
    {
        // validation for constraint: array
        if ('' !== ($zahlungsweiseArrayErrorMessage = self::validateZahlungsweiseForArrayConstraintsFromSetZahlungsweise($zahlungsweise))) {
            throw new \InvalidArgumentException($zahlungsweiseArrayErrorMessage, __LINE__);
        }
        $this->zahlungsweise = $zahlungsweise;
        return $this;
    }
    /**
     * Add item to zahlungsweise value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Zahlungsweise $item
     * @return \StructType\Onlinedienst
     */
    public function addToZahlungsweise(\StructType\Code_Zahlungsweise $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_Zahlungsweise) {
            throw new \InvalidArgumentException(sprintf('The zahlungsweise property can only contain items of type \StructType\Code_Zahlungsweise, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zahlungsweise[] = $item;
        return $this;
    }
    /**
     * Get vertrauensniveau value
     * @return \StructType\Code_Vertrauensniveau|null
     */
    public function getVertrauensniveau()
    {
        return $this->vertrauensniveau;
    }
    /**
     * Set vertrauensniveau value
     * @param \StructType\Code_Vertrauensniveau $vertrauensniveau
     * @return \StructType\Onlinedienst
     */
    public function setVertrauensniveau(\StructType\Code_Vertrauensniveau $vertrauensniveau = null)
    {
        $this->vertrauensniveau = $vertrauensniveau;
        return $this;
    }
    /**
     * Get identifizierungsmittel value
     * @return \StructType\Code_Identifizierungsmittel[]|null
     */
    public function getIdentifizierungsmittel()
    {
        return $this->identifizierungsmittel;
    }
    /**
     * This method is responsible for validating the values passed to the setIdentifizierungsmittel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentifizierungsmittel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdentifizierungsmittelForArrayConstraintsFromSetIdentifizierungsmittel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstIdentifizierungsmittelItem) {
            // validation for constraint: itemType
            if (!$onlinedienstIdentifizierungsmittelItem instanceof \StructType\Code_Identifizierungsmittel) {
                $invalidValues[] = is_object($onlinedienstIdentifizierungsmittelItem) ? get_class($onlinedienstIdentifizierungsmittelItem) : sprintf('%s(%s)', gettype($onlinedienstIdentifizierungsmittelItem), var_export($onlinedienstIdentifizierungsmittelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The identifizierungsmittel property can only contain items of type \StructType\Code_Identifizierungsmittel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set identifizierungsmittel value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Identifizierungsmittel[] $identifizierungsmittel
     * @return \StructType\Onlinedienst
     */
    public function setIdentifizierungsmittel(array $identifizierungsmittel = array())
    {
        // validation for constraint: array
        if ('' !== ($identifizierungsmittelArrayErrorMessage = self::validateIdentifizierungsmittelForArrayConstraintsFromSetIdentifizierungsmittel($identifizierungsmittel))) {
            throw new \InvalidArgumentException($identifizierungsmittelArrayErrorMessage, __LINE__);
        }
        $this->identifizierungsmittel = $identifizierungsmittel;
        return $this;
    }
    /**
     * Add item to identifizierungsmittel value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Identifizierungsmittel $item
     * @return \StructType\Onlinedienst
     */
    public function addToIdentifizierungsmittel(\StructType\Code_Identifizierungsmittel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_Identifizierungsmittel) {
            throw new \InvalidArgumentException(sprintf('The identifizierungsmittel property can only contain items of type \StructType\Code_Identifizierungsmittel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->identifizierungsmittel[] = $item;
        return $this;
    }
    /**
     * Get logo value
     * @return \StructType\Identifikator[]|null
     */
    public function getLogo()
    {
        return $this->logo;
    }
    /**
     * This method is responsible for validating the values passed to the setLogo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLogo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLogoForArrayConstraintsFromSetLogo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstLogoItem) {
            // validation for constraint: itemType
            if (!$onlinedienstLogoItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($onlinedienstLogoItem) ? get_class($onlinedienstLogoItem) : sprintf('%s(%s)', gettype($onlinedienstLogoItem), var_export($onlinedienstLogoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The logo property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set logo value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $logo
     * @return \StructType\Onlinedienst
     */
    public function setLogo(array $logo = array())
    {
        // validation for constraint: array
        if ('' !== ($logoArrayErrorMessage = self::validateLogoForArrayConstraintsFromSetLogo($logo))) {
            throw new \InvalidArgumentException($logoArrayErrorMessage, __LINE__);
        }
        $this->logo = $logo;
        return $this;
    }
    /**
     * Add item to logo value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Onlinedienst
     */
    public function addToLogo(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The logo property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->logo[] = $item;
        return $this;
    }
    /**
     * Get hilfeLink value
     * @return \StructType\HyperlinkErweitert[]|null
     */
    public function getHilfeLink()
    {
        return $this->hilfeLink;
    }
    /**
     * This method is responsible for validating the values passed to the setHilfeLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHilfeLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHilfeLinkForArrayConstraintsFromSetHilfeLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstHilfeLinkItem) {
            // validation for constraint: itemType
            if (!$onlinedienstHilfeLinkItem instanceof \StructType\HyperlinkErweitert) {
                $invalidValues[] = is_object($onlinedienstHilfeLinkItem) ? get_class($onlinedienstHilfeLinkItem) : sprintf('%s(%s)', gettype($onlinedienstHilfeLinkItem), var_export($onlinedienstHilfeLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hilfeLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hilfeLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert[] $hilfeLink
     * @return \StructType\Onlinedienst
     */
    public function setHilfeLink(array $hilfeLink = array())
    {
        // validation for constraint: array
        if ('' !== ($hilfeLinkArrayErrorMessage = self::validateHilfeLinkForArrayConstraintsFromSetHilfeLink($hilfeLink))) {
            throw new \InvalidArgumentException($hilfeLinkArrayErrorMessage, __LINE__);
        }
        $this->hilfeLink = $hilfeLink;
        return $this;
    }
    /**
     * Add item to hilfeLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert $item
     * @return \StructType\Onlinedienst
     */
    public function addToHilfeLink(\StructType\HyperlinkErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HyperlinkErweitert) {
            throw new \InvalidArgumentException(sprintf('The hilfeLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hilfeLink[] = $item;
        return $this;
    }
    /**
     * Get hilfeText value
     * @return \StructType\String_Localized[]|null
     */
    public function getHilfeText()
    {
        return $this->hilfeText;
    }
    /**
     * This method is responsible for validating the values passed to the setHilfeText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHilfeText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHilfeTextForArrayConstraintsFromSetHilfeText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstHilfeTextItem) {
            // validation for constraint: itemType
            if (!$onlinedienstHilfeTextItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($onlinedienstHilfeTextItem) ? get_class($onlinedienstHilfeTextItem) : sprintf('%s(%s)', gettype($onlinedienstHilfeTextItem), var_export($onlinedienstHilfeTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The hilfeText property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set hilfeText value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $hilfeText
     * @return \StructType\Onlinedienst
     */
    public function setHilfeText(array $hilfeText = array())
    {
        // validation for constraint: array
        if ('' !== ($hilfeTextArrayErrorMessage = self::validateHilfeTextForArrayConstraintsFromSetHilfeText($hilfeText))) {
            throw new \InvalidArgumentException($hilfeTextArrayErrorMessage, __LINE__);
        }
        $this->hilfeText = $hilfeText;
        return $this;
    }
    /**
     * Add item to hilfeText value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Onlinedienst
     */
    public function addToHilfeText(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The hilfeText property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->hilfeText[] = $item;
        return $this;
    }
    /**
     * Get herausgeber value
     * @return \StructType\Herausgeber|null
     */
    public function getHerausgeber()
    {
        return $this->herausgeber;
    }
    /**
     * Set herausgeber value
     * @param \StructType\Herausgeber $herausgeber
     * @return \StructType\Onlinedienst
     */
    public function setHerausgeber(\StructType\Herausgeber $herausgeber = null)
    {
        $this->herausgeber = $herausgeber;
        return $this;
    }
    /**
     * Get versionsinformation value
     * @return \StructType\Versionsinformation|null
     */
    public function getVersionsinformation()
    {
        return $this->versionsinformation;
    }
    /**
     * Set versionsinformation value
     * @param \StructType\Versionsinformation $versionsinformation
     * @return \StructType\Onlinedienst
     */
    public function setVersionsinformation(\StructType\Versionsinformation $versionsinformation = null)
    {
        $this->versionsinformation = $versionsinformation;
        return $this;
    }
    /**
     * Get sprachversion value
     * @return \StructType\Sprachversion[]|null
     */
    public function getSprachversion()
    {
        return $this->sprachversion;
    }
    /**
     * This method is responsible for validating the values passed to the setSprachversion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprachversion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSprachversionForArrayConstraintsFromSetSprachversion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstSprachversionItem) {
            // validation for constraint: itemType
            if (!$onlinedienstSprachversionItem instanceof \StructType\Sprachversion) {
                $invalidValues[] = is_object($onlinedienstSprachversionItem) ? get_class($onlinedienstSprachversionItem) : sprintf('%s(%s)', gettype($onlinedienstSprachversionItem), var_export($onlinedienstSprachversionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sprachversion property can only contain items of type \StructType\Sprachversion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sprachversion value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprachversion[] $sprachversion
     * @return \StructType\Onlinedienst
     */
    public function setSprachversion(array $sprachversion = array())
    {
        // validation for constraint: array
        if ('' !== ($sprachversionArrayErrorMessage = self::validateSprachversionForArrayConstraintsFromSetSprachversion($sprachversion))) {
            throw new \InvalidArgumentException($sprachversionArrayErrorMessage, __LINE__);
        }
        $this->sprachversion = $sprachversion;
        return $this;
    }
    /**
     * Add item to sprachversion value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprachversion $item
     * @return \StructType\Onlinedienst
     */
    public function addToSprachversion(\StructType\Sprachversion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sprachversion) {
            throw new \InvalidArgumentException(sprintf('The sprachversion property can only contain items of type \StructType\Sprachversion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sprachversion[] = $item;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onlinedienstGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$onlinedienstGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($onlinedienstGueltigkeitItem) ? get_class($onlinedienstGueltigkeitItem) : sprintf('%s(%s)', gettype($onlinedienstGueltigkeitItem), var_export($onlinedienstGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Onlinedienst
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Onlinedienst
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
