<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Number_PropertyType StructType
 * @subpackage Structs
 */
class Number_PropertyType extends AbstractStructBase
{
    /**
     * The Real
     * @var float
     */
    public $Real;
    /**
     * The Decimal
     * @var float
     */
    public $Decimal;
    /**
     * The Integer
     * @var int
     */
    public $Integer;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for Number_PropertyType
     * @uses Number_PropertyType::setReal()
     * @uses Number_PropertyType::setDecimal()
     * @uses Number_PropertyType::setInteger()
     * @uses Number_PropertyType::setNilReason()
     * @param float $real
     * @param float $decimal
     * @param int $integer
     * @param string $nilReason
     */
    public function __construct($real = null, $decimal = null, $integer = null, $nilReason = null)
    {
        $this
            ->setReal($real)
            ->setDecimal($decimal)
            ->setInteger($integer)
            ->setNilReason($nilReason);
    }
    /**
     * Get Real value
     * @return float|null
     */
    public function getReal()
    {
        return $this->Real;
    }
    /**
     * Set Real value
     * @param float $real
     * @return \StructType\Number_PropertyType
     */
    public function setReal($real = null)
    {
        // validation for constraint: float
        if (!is_null($real) && !(is_float($real) || is_numeric($real))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($real, true), gettype($real)), __LINE__);
        }
        $this->Real = $real;
        return $this;
    }
    /**
     * Get Decimal value
     * @return float|null
     */
    public function getDecimal()
    {
        return $this->Decimal;
    }
    /**
     * Set Decimal value
     * @param float $decimal
     * @return \StructType\Number_PropertyType
     */
    public function setDecimal($decimal = null)
    {
        // validation for constraint: float
        if (!is_null($decimal) && !(is_float($decimal) || is_numeric($decimal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($decimal, true), gettype($decimal)), __LINE__);
        }
        $this->Decimal = $decimal;
        return $this;
    }
    /**
     * Get Integer value
     * @return int|null
     */
    public function getInteger()
    {
        return $this->Integer;
    }
    /**
     * Set Integer value
     * @param int $integer
     * @return \StructType\Number_PropertyType
     */
    public function setInteger($integer = null)
    {
        // validation for constraint: int
        if (!is_null($integer) && !(is_int($integer) || ctype_digit($integer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($integer, true), gettype($integer)), __LINE__);
        }
        $this->Integer = $integer;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\Number_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
