<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NameOrganisation StructType
 * Meta information extracted from the WSDL
 * - documentation: "NameOrganisation" fasst die Angaben zum Namen einer Organisation zusammen.
 * @subpackage Structs
 */
class NameOrganisation extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Offizieller Name einer Organisation. Entspricht bei registrierten Organisationen dem im Register eingetragenen Namen.Im Kontext XZuFi soll hier der vollständige Name der Organisationseinheit angegeben werden, d.h. die vollständige
     * Hierarchie. Zum Beispiel "Stadtverwaltung Musterstadt - Dezernat II - Bürgerservice".
     * - maxOccurs: unbounded
     * @var \StructType\String_Localized[]
     */
    public $name;
    /**
     * The kurzbezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Kurzbezeichnung des Namens einer Organisation.Im Kontext XZuFi soll hier der einfache Name der Organisationseinheit angegeben werden, d.h.ohne die vollständige Hierarchie. Zum Beispiel "Bürgerservice".
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $kurzbezeichnung;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Optionaler Gültigkeitszeitraum des Namens der Organisation
     * - minOccurs: 0
     * @var \StructType\Zeitraum
     */
    public $gueltigkeit;
    /**
     * Constructor method for NameOrganisation
     * @uses NameOrganisation::setName()
     * @uses NameOrganisation::setKurzbezeichnung()
     * @uses NameOrganisation::setGueltigkeit()
     * @param \StructType\String_Localized[] $name
     * @param \StructType\String_Localized[] $kurzbezeichnung
     * @param \StructType\Zeitraum $gueltigkeit
     */
    public function __construct(array $name = array(), array $kurzbezeichnung = array(), \StructType\Zeitraum $gueltigkeit = null)
    {
        $this
            ->setName($name)
            ->setKurzbezeichnung($kurzbezeichnung)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get name value
     * @return \StructType\String_Localized[]|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * This method is responsible for validating the values passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameForArrayConstraintsFromSetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nameOrganisationNameItem) {
            // validation for constraint: itemType
            if (!$nameOrganisationNameItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($nameOrganisationNameItem) ? get_class($nameOrganisationNameItem) : sprintf('%s(%s)', gettype($nameOrganisationNameItem), var_export($nameOrganisationNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The name property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set name value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $name
     * @return \StructType\NameOrganisation
     */
    public function setName(array $name = array())
    {
        // validation for constraint: array
        if ('' !== ($nameArrayErrorMessage = self::validateNameForArrayConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameArrayErrorMessage, __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Add item to name value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\NameOrganisation
     */
    public function addToName(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The name property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->name[] = $item;
        return $this;
    }
    /**
     * Get kurzbezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getKurzbezeichnung()
    {
        return $this->kurzbezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setKurzbezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKurzbezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $nameOrganisationKurzbezeichnungItem) {
            // validation for constraint: itemType
            if (!$nameOrganisationKurzbezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($nameOrganisationKurzbezeichnungItem) ? get_class($nameOrganisationKurzbezeichnungItem) : sprintf('%s(%s)', gettype($nameOrganisationKurzbezeichnungItem), var_export($nameOrganisationKurzbezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kurzbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $kurzbezeichnung
     * @return \StructType\NameOrganisation
     */
    public function setKurzbezeichnung(array $kurzbezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($kurzbezeichnungArrayErrorMessage = self::validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung($kurzbezeichnung))) {
            throw new \InvalidArgumentException($kurzbezeichnungArrayErrorMessage, __LINE__);
        }
        $this->kurzbezeichnung = $kurzbezeichnung;
        return $this;
    }
    /**
     * Add item to kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\NameOrganisation
     */
    public function addToKurzbezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The kurzbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kurzbezeichnung[] = $item;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * Set gueltigkeit value
     * @param \StructType\Zeitraum $gueltigkeit
     * @return \StructType\NameOrganisation
     */
    public function setGueltigkeit(\StructType\Zeitraum $gueltigkeit = null)
    {
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
}
