<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultiSurfaceType StructType
 * @subpackage Structs
 */
class MultiSurfaceType extends AbstractStructBase
{
    /**
     * The surfaceMember
     * @var \StructType\SurfacePropertyType
     */
    public $surfaceMember;
    /**
     * The surfaceMembers
     * @var \StructType\SurfaceArrayPropertyType
     */
    public $surfaceMembers;
    /**
     * Constructor method for MultiSurfaceType
     * @uses MultiSurfaceType::setSurfaceMember()
     * @uses MultiSurfaceType::setSurfaceMembers()
     * @param \StructType\SurfacePropertyType $surfaceMember
     * @param \StructType\SurfaceArrayPropertyType $surfaceMembers
     */
    public function __construct(\StructType\SurfacePropertyType $surfaceMember = null, \StructType\SurfaceArrayPropertyType $surfaceMembers = null)
    {
        $this
            ->setSurfaceMember($surfaceMember)
            ->setSurfaceMembers($surfaceMembers);
    }
    /**
     * Get surfaceMember value
     * @return \StructType\SurfacePropertyType|null
     */
    public function getSurfaceMember()
    {
        return $this->surfaceMember;
    }
    /**
     * Set surfaceMember value
     * @param \StructType\SurfacePropertyType $surfaceMember
     * @return \StructType\MultiSurfaceType
     */
    public function setSurfaceMember(\StructType\SurfacePropertyType $surfaceMember = null)
    {
        $this->surfaceMember = $surfaceMember;
        return $this;
    }
    /**
     * Get surfaceMembers value
     * @return \StructType\SurfaceArrayPropertyType|null
     */
    public function getSurfaceMembers()
    {
        return $this->surfaceMembers;
    }
    /**
     * Set surfaceMembers value
     * @param \StructType\SurfaceArrayPropertyType $surfaceMembers
     * @return \StructType\MultiSurfaceType
     */
    public function setSurfaceMembers(\StructType\SurfaceArrayPropertyType $surfaceMembers = null)
    {
        $this->surfaceMembers = $surfaceMembers;
        return $this;
    }
}
