<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultiSolidType StructType
 * @subpackage Structs
 */
class MultiSolidType extends AbstractStructBase
{
    /**
     * The solidMember
     * @var \StructType\SolidPropertyType
     */
    public $solidMember;
    /**
     * The solidMembers
     * @var \StructType\SolidArrayPropertyType
     */
    public $solidMembers;
    /**
     * Constructor method for MultiSolidType
     * @uses MultiSolidType::setSolidMember()
     * @uses MultiSolidType::setSolidMembers()
     * @param \StructType\SolidPropertyType $solidMember
     * @param \StructType\SolidArrayPropertyType $solidMembers
     */
    public function __construct(\StructType\SolidPropertyType $solidMember = null, \StructType\SolidArrayPropertyType $solidMembers = null)
    {
        $this
            ->setSolidMember($solidMember)
            ->setSolidMembers($solidMembers);
    }
    /**
     * Get solidMember value
     * @return \StructType\SolidPropertyType|null
     */
    public function getSolidMember()
    {
        return $this->solidMember;
    }
    /**
     * Set solidMember value
     * @param \StructType\SolidPropertyType $solidMember
     * @return \StructType\MultiSolidType
     */
    public function setSolidMember(\StructType\SolidPropertyType $solidMember = null)
    {
        $this->solidMember = $solidMember;
        return $this;
    }
    /**
     * Get solidMembers value
     * @return \StructType\SolidArrayPropertyType|null
     */
    public function getSolidMembers()
    {
        return $this->solidMembers;
    }
    /**
     * Set solidMembers value
     * @param \StructType\SolidArrayPropertyType $solidMembers
     * @return \StructType\MultiSolidType
     */
    public function setSolidMembers(\StructType\SolidArrayPropertyType $solidMembers = null)
    {
        $this->solidMembers = $solidMembers;
        return $this;
    }
}
