<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultiPointType StructType
 * @subpackage Structs
 */
class MultiPointType extends AbstractStructBase
{
    /**
     * The pointMember
     * @var \StructType\PointPropertyType
     */
    public $pointMember;
    /**
     * The pointMembers
     * @var \StructType\PointArrayPropertyType
     */
    public $pointMembers;
    /**
     * Constructor method for MultiPointType
     * @uses MultiPointType::setPointMember()
     * @uses MultiPointType::setPointMembers()
     * @param \StructType\PointPropertyType $pointMember
     * @param \StructType\PointArrayPropertyType $pointMembers
     */
    public function __construct(\StructType\PointPropertyType $pointMember = null, \StructType\PointArrayPropertyType $pointMembers = null)
    {
        $this
            ->setPointMember($pointMember)
            ->setPointMembers($pointMembers);
    }
    /**
     * Get pointMember value
     * @return \StructType\PointPropertyType|null
     */
    public function getPointMember()
    {
        return $this->pointMember;
    }
    /**
     * Set pointMember value
     * @param \StructType\PointPropertyType $pointMember
     * @return \StructType\MultiPointType
     */
    public function setPointMember(\StructType\PointPropertyType $pointMember = null)
    {
        $this->pointMember = $pointMember;
        return $this;
    }
    /**
     * Get pointMembers value
     * @return \StructType\PointArrayPropertyType|null
     */
    public function getPointMembers()
    {
        return $this->pointMembers;
    }
    /**
     * Set pointMembers value
     * @param \StructType\PointArrayPropertyType $pointMembers
     * @return \StructType\MultiPointType
     */
    public function setPointMembers(\StructType\PointArrayPropertyType $pointMembers = null)
    {
        $this->pointMembers = $pointMembers;
        return $this;
    }
}
