<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MappingRuleType StructType
 * @subpackage Structs
 */
class MappingRuleType extends AbstractStructBase
{
    /**
     * The ruleDefinition
     * @var string
     */
    public $ruleDefinition;
    /**
     * The ruleReference
     * @var \StructType\ReferenceType
     */
    public $ruleReference;
    /**
     * Constructor method for MappingRuleType
     * @uses MappingRuleType::setRuleDefinition()
     * @uses MappingRuleType::setRuleReference()
     * @param string $ruleDefinition
     * @param \StructType\ReferenceType $ruleReference
     */
    public function __construct($ruleDefinition = null, \StructType\ReferenceType $ruleReference = null)
    {
        $this
            ->setRuleDefinition($ruleDefinition)
            ->setRuleReference($ruleReference);
    }
    /**
     * Get ruleDefinition value
     * @return string|null
     */
    public function getRuleDefinition()
    {
        return $this->ruleDefinition;
    }
    /**
     * Set ruleDefinition value
     * @param string $ruleDefinition
     * @return \StructType\MappingRuleType
     */
    public function setRuleDefinition($ruleDefinition = null)
    {
        // validation for constraint: string
        if (!is_null($ruleDefinition) && !is_string($ruleDefinition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleDefinition, true), gettype($ruleDefinition)), __LINE__);
        }
        $this->ruleDefinition = $ruleDefinition;
        return $this;
    }
    /**
     * Get ruleReference value
     * @return \StructType\ReferenceType|null
     */
    public function getRuleReference()
    {
        return $this->ruleReference;
    }
    /**
     * Set ruleReference value
     * @param \StructType\ReferenceType $ruleReference
     * @return \StructType\MappingRuleType
     */
    public function setRuleReference(\StructType\ReferenceType $ruleReference = null)
    {
        $this->ruleReference = $ruleReference;
        return $this;
    }
}
