<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MD_Keywords_Type StructType
 * @subpackage Structs
 */
class MD_Keywords_Type extends AbstractStructBase
{
    /**
     * The keyword
     * @var \StructType\CharacterString_PropertyType
     */
    public $keyword;
    /**
     * The type
     * @var \StructType\MD_KeywordTypeCode_PropertyType
     */
    public $type;
    /**
     * The thesaurusName
     * @var \StructType\CI_Citation_PropertyType
     */
    public $thesaurusName;
    /**
     * Constructor method for MD_Keywords_Type
     * @uses MD_Keywords_Type::setKeyword()
     * @uses MD_Keywords_Type::setType()
     * @uses MD_Keywords_Type::setThesaurusName()
     * @param \StructType\CharacterString_PropertyType $keyword
     * @param \StructType\MD_KeywordTypeCode_PropertyType $type
     * @param \StructType\CI_Citation_PropertyType $thesaurusName
     */
    public function __construct(\StructType\CharacterString_PropertyType $keyword = null, \StructType\MD_KeywordTypeCode_PropertyType $type = null, \StructType\CI_Citation_PropertyType $thesaurusName = null)
    {
        $this
            ->setKeyword($keyword)
            ->setType($type)
            ->setThesaurusName($thesaurusName);
    }
    /**
     * Get keyword value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getKeyword()
    {
        return $this->keyword;
    }
    /**
     * Set keyword value
     * @param \StructType\CharacterString_PropertyType $keyword
     * @return \StructType\MD_Keywords_Type
     */
    public function setKeyword(\StructType\CharacterString_PropertyType $keyword = null)
    {
        $this->keyword = $keyword;
        return $this;
    }
    /**
     * Get type value
     * @return \StructType\MD_KeywordTypeCode_PropertyType|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param \StructType\MD_KeywordTypeCode_PropertyType $type
     * @return \StructType\MD_Keywords_Type
     */
    public function setType(\StructType\MD_KeywordTypeCode_PropertyType $type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get thesaurusName value
     * @return \StructType\CI_Citation_PropertyType|null
     */
    public function getThesaurusName()
    {
        return $this->thesaurusName;
    }
    /**
     * Set thesaurusName value
     * @param \StructType\CI_Citation_PropertyType $thesaurusName
     * @return \StructType\MD_Keywords_Type
     */
    public function setThesaurusName(\StructType\CI_Citation_PropertyType $thesaurusName = null)
    {
        $this->thesaurusName = $thesaurusName;
        return $this;
    }
}
