<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MD_DataIdentification_Type StructType
 * @subpackage Structs
 */
class MD_DataIdentification_Type extends AbstractStructBase
{
    /**
     * The spatialRepresentationType
     * @var \StructType\MD_SpatialRepresentationTypeCode_PropertyType
     */
    public $spatialRepresentationType;
    /**
     * The spatialResolution
     * @var \StructType\MD_Resolution_PropertyType
     */
    public $spatialResolution;
    /**
     * The language
     * @var \StructType\CharacterString_PropertyType
     */
    public $language;
    /**
     * The characterSet
     * @var \StructType\MD_CharacterSetCode_PropertyType
     */
    public $characterSet;
    /**
     * The topicCategory
     * @var \StructType\MD_TopicCategoryCode_PropertyType
     */
    public $topicCategory;
    /**
     * The environmentDescription
     * @var \StructType\CharacterString_PropertyType
     */
    public $environmentDescription;
    /**
     * The extent
     * @var \StructType\EX_Extent_PropertyType
     */
    public $extent;
    /**
     * The supplementalInformation
     * @var \StructType\CharacterString_PropertyType
     */
    public $supplementalInformation;
    /**
     * Constructor method for MD_DataIdentification_Type
     * @uses MD_DataIdentification_Type::setSpatialRepresentationType()
     * @uses MD_DataIdentification_Type::setSpatialResolution()
     * @uses MD_DataIdentification_Type::setLanguage()
     * @uses MD_DataIdentification_Type::setCharacterSet()
     * @uses MD_DataIdentification_Type::setTopicCategory()
     * @uses MD_DataIdentification_Type::setEnvironmentDescription()
     * @uses MD_DataIdentification_Type::setExtent()
     * @uses MD_DataIdentification_Type::setSupplementalInformation()
     * @param \StructType\MD_SpatialRepresentationTypeCode_PropertyType $spatialRepresentationType
     * @param \StructType\MD_Resolution_PropertyType $spatialResolution
     * @param \StructType\CharacterString_PropertyType $language
     * @param \StructType\MD_CharacterSetCode_PropertyType $characterSet
     * @param \StructType\MD_TopicCategoryCode_PropertyType $topicCategory
     * @param \StructType\CharacterString_PropertyType $environmentDescription
     * @param \StructType\EX_Extent_PropertyType $extent
     * @param \StructType\CharacterString_PropertyType $supplementalInformation
     */
    public function __construct(\StructType\MD_SpatialRepresentationTypeCode_PropertyType $spatialRepresentationType = null, \StructType\MD_Resolution_PropertyType $spatialResolution = null, \StructType\CharacterString_PropertyType $language = null, \StructType\MD_CharacterSetCode_PropertyType $characterSet = null, \StructType\MD_TopicCategoryCode_PropertyType $topicCategory = null, \StructType\CharacterString_PropertyType $environmentDescription = null, \StructType\EX_Extent_PropertyType $extent = null, \StructType\CharacterString_PropertyType $supplementalInformation = null)
    {
        $this
            ->setSpatialRepresentationType($spatialRepresentationType)
            ->setSpatialResolution($spatialResolution)
            ->setLanguage($language)
            ->setCharacterSet($characterSet)
            ->setTopicCategory($topicCategory)
            ->setEnvironmentDescription($environmentDescription)
            ->setExtent($extent)
            ->setSupplementalInformation($supplementalInformation);
    }
    /**
     * Get spatialRepresentationType value
     * @return \StructType\MD_SpatialRepresentationTypeCode_PropertyType|null
     */
    public function getSpatialRepresentationType()
    {
        return $this->spatialRepresentationType;
    }
    /**
     * Set spatialRepresentationType value
     * @param \StructType\MD_SpatialRepresentationTypeCode_PropertyType $spatialRepresentationType
     * @return \StructType\MD_DataIdentification_Type
     */
    public function setSpatialRepresentationType(\StructType\MD_SpatialRepresentationTypeCode_PropertyType $spatialRepresentationType = null)
    {
        $this->spatialRepresentationType = $spatialRepresentationType;
        return $this;
    }
    /**
     * Get spatialResolution value
     * @return \StructType\MD_Resolution_PropertyType|null
     */
    public function getSpatialResolution()
    {
        return $this->spatialResolution;
    }
    /**
     * Set spatialResolution value
     * @param \StructType\MD_Resolution_PropertyType $spatialResolution
     * @return \StructType\MD_DataIdentification_Type
     */
    public function setSpatialResolution(\StructType\MD_Resolution_PropertyType $spatialResolution = null)
    {
        $this->spatialResolution = $spatialResolution;
        return $this;
    }
    /**
     * Get language value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param \StructType\CharacterString_PropertyType $language
     * @return \StructType\MD_DataIdentification_Type
     */
    public function setLanguage(\StructType\CharacterString_PropertyType $language = null)
    {
        $this->language = $language;
        return $this;
    }
    /**
     * Get characterSet value
     * @return \StructType\MD_CharacterSetCode_PropertyType|null
     */
    public function getCharacterSet()
    {
        return $this->characterSet;
    }
    /**
     * Set characterSet value
     * @param \StructType\MD_CharacterSetCode_PropertyType $characterSet
     * @return \StructType\MD_DataIdentification_Type
     */
    public function setCharacterSet(\StructType\MD_CharacterSetCode_PropertyType $characterSet = null)
    {
        $this->characterSet = $characterSet;
        return $this;
    }
    /**
     * Get topicCategory value
     * @return \StructType\MD_TopicCategoryCode_PropertyType|null
     */
    public function getTopicCategory()
    {
        return $this->topicCategory;
    }
    /**
     * Set topicCategory value
     * @param \StructType\MD_TopicCategoryCode_PropertyType $topicCategory
     * @return \StructType\MD_DataIdentification_Type
     */
    public function setTopicCategory(\StructType\MD_TopicCategoryCode_PropertyType $topicCategory = null)
    {
        $this->topicCategory = $topicCategory;
        return $this;
    }
    /**
     * Get environmentDescription value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getEnvironmentDescription()
    {
        return $this->environmentDescription;
    }
    /**
     * Set environmentDescription value
     * @param \StructType\CharacterString_PropertyType $environmentDescription
     * @return \StructType\MD_DataIdentification_Type
     */
    public function setEnvironmentDescription(\StructType\CharacterString_PropertyType $environmentDescription = null)
    {
        $this->environmentDescription = $environmentDescription;
        return $this;
    }
    /**
     * Get extent value
     * @return \StructType\EX_Extent_PropertyType|null
     */
    public function getExtent()
    {
        return $this->extent;
    }
    /**
     * Set extent value
     * @param \StructType\EX_Extent_PropertyType $extent
     * @return \StructType\MD_DataIdentification_Type
     */
    public function setExtent(\StructType\EX_Extent_PropertyType $extent = null)
    {
        $this->extent = $extent;
        return $this;
    }
    /**
     * Get supplementalInformation value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getSupplementalInformation()
    {
        return $this->supplementalInformation;
    }
    /**
     * Set supplementalInformation value
     * @param \StructType\CharacterString_PropertyType $supplementalInformation
     * @return \StructType\MD_DataIdentification_Type
     */
    public function setSupplementalInformation(\StructType\CharacterString_PropertyType $supplementalInformation = null)
    {
        $this->supplementalInformation = $supplementalInformation;
        return $this;
    }
}
