<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoescheObjekt StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp zum Löschen von Objekten.
 * @subpackage Structs
 */
class LoescheObjekt extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: ID des zu löschenden Objekts.
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The klasse
     * Meta information extracted from the WSDL
     * - documentation: Optionale Angabe der Objektklasse des zu löschenden Objekts. Dies ist insbesondere notwendig, wenn die IDs im Zielsystem nicht klassenübergreifend eindeutig sind. Angegeben muss hier exakt der Name der Klasse aus dem Baukasten, wie
     * z.B. "Onlinedienst", "Gebiet", "Zustaendigkeit" oder "Kontaktperson". Bei Klassen mit Veerbung wird immer die oberste Klasse angegeben.
     * - use: optional
     * @var string
     */
    public $klasse;
    /**
     * Constructor method for LoescheObjekt
     * @uses LoescheObjekt::setId()
     * @uses LoescheObjekt::setKlasse()
     * @param \StructType\Identifikator $id
     * @param string $klasse
     */
    public function __construct(\StructType\Identifikator $id = null, $klasse = null)
    {
        $this
            ->setId($id)
            ->setKlasse($klasse);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\LoescheObjekt
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get klasse value
     * @return string|null
     */
    public function getKlasse()
    {
        return $this->klasse;
    }
    /**
     * Set klasse value
     * @param string $klasse
     * @return \StructType\LoescheObjekt
     */
    public function setKlasse($klasse = null)
    {
        // validation for constraint: string
        if (!is_null($klasse) && !is_string($klasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($klasse, true), gettype($klasse)), __LINE__);
        }
        $this->klasse = $klasse;
        return $this;
    }
}
