<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocalName_PropertyType StructType
 * @subpackage Structs
 */
class LocalName_PropertyType extends AbstractStructBase
{
    /**
     * The LocalName
     * @var \StructType\CodeType
     */
    public $LocalName;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for LocalName_PropertyType
     * @uses LocalName_PropertyType::setLocalName()
     * @uses LocalName_PropertyType::setNilReason()
     * @param \StructType\CodeType $localName
     * @param string $nilReason
     */
    public function __construct(\StructType\CodeType $localName = null, $nilReason = null)
    {
        $this
            ->setLocalName($localName)
            ->setNilReason($nilReason);
    }
    /**
     * Get LocalName value
     * @return \StructType\CodeType|null
     */
    public function getLocalName()
    {
        return $this->LocalName;
    }
    /**
     * Set LocalName value
     * @param \StructType\CodeType $localName
     * @return \StructType\LocalName_PropertyType
     */
    public function setLocalName(\StructType\CodeType $localName = null)
    {
        $this->LocalName = $localName;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\LocalName_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
