<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeistungsverrichtungAuswahlID StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp zur Auswahl der Verrichtung einer Leistung per Code oder ID. Es kann entweder die LeiKa-Verrichtung oder eine Individuelle angegeben werden.
 * @subpackage Structs
 */
class LeistungsverrichtungAuswahlID extends AbstractStructBase
{
    /**
     * The verrichtungLeiKa
     * Meta information extracted from the WSDL
     * - documentation: Code der Verrichtung im LeiKa.
     * - choice: verrichtungLeiKa | verrichtungIndividuellID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Code_LeiKaVerrichtungskennung
     */
    public $verrichtungLeiKa;
    /**
     * The verrichtungIndividuellID
     * Meta information extracted from the WSDL
     * - documentation: ID der Leistungskategorie der Leistungsklasse Verrichtungen (individuelle Verrichtung).
     * - choice: verrichtungLeiKa | verrichtungIndividuellID
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Identifikator
     */
    public $verrichtungIndividuellID;
    /**
     * Constructor method for LeistungsverrichtungAuswahlID
     * @uses LeistungsverrichtungAuswahlID::setVerrichtungLeiKa()
     * @uses LeistungsverrichtungAuswahlID::setVerrichtungIndividuellID()
     * @param \StructType\Code_LeiKaVerrichtungskennung $verrichtungLeiKa
     * @param \StructType\Identifikator $verrichtungIndividuellID
     */
    public function __construct(\StructType\Code_LeiKaVerrichtungskennung $verrichtungLeiKa = null, \StructType\Identifikator $verrichtungIndividuellID = null)
    {
        $this
            ->setVerrichtungLeiKa($verrichtungLeiKa)
            ->setVerrichtungIndividuellID($verrichtungIndividuellID);
    }
    /**
     * Get verrichtungLeiKa value
     * @return \StructType\Code_LeiKaVerrichtungskennung|null
     */
    public function getVerrichtungLeiKa()
    {
        return isset($this->verrichtungLeiKa) ? $this->verrichtungLeiKa : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVerrichtungLeiKa method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerrichtungLeiKa method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVerrichtungLeiKaForChoiceConstraintsFromSetVerrichtungLeiKa($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'verrichtungIndividuellID',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property verrichtungLeiKa can\'t be set as the property %s is already set. Only one property must be set among these properties: verrichtungLeiKa, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set verrichtungLeiKa value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Code_LeiKaVerrichtungskennung $verrichtungLeiKa
     * @return \StructType\LeistungsverrichtungAuswahlID
     */
    public function setVerrichtungLeiKa(\StructType\Code_LeiKaVerrichtungskennung $verrichtungLeiKa = null)
    {
        // validation for constraint: choice(verrichtungLeiKa, verrichtungIndividuellID)
        if ('' !== ($verrichtungLeiKaChoiceErrorMessage = self::validateVerrichtungLeiKaForChoiceConstraintsFromSetVerrichtungLeiKa($verrichtungLeiKa))) {
            throw new \InvalidArgumentException($verrichtungLeiKaChoiceErrorMessage, __LINE__);
        }
        if (is_null($verrichtungLeiKa) || (is_array($verrichtungLeiKa) && empty($verrichtungLeiKa))) {
            unset($this->verrichtungLeiKa);
        } else {
            $this->verrichtungLeiKa = $verrichtungLeiKa;
        }
        return $this;
    }
    /**
     * Get verrichtungIndividuellID value
     * @return \StructType\Identifikator|null
     */
    public function getVerrichtungIndividuellID()
    {
        return isset($this->verrichtungIndividuellID) ? $this->verrichtungIndividuellID : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVerrichtungIndividuellID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerrichtungIndividuellID method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVerrichtungIndividuellIDForChoiceConstraintsFromSetVerrichtungIndividuellID($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'verrichtungLeiKa',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property verrichtungIndividuellID can\'t be set as the property %s is already set. Only one property must be set among these properties: verrichtungIndividuellID, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set verrichtungIndividuellID value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $verrichtungIndividuellID
     * @return \StructType\LeistungsverrichtungAuswahlID
     */
    public function setVerrichtungIndividuellID(\StructType\Identifikator $verrichtungIndividuellID = null)
    {
        // validation for constraint: choice(verrichtungLeiKa, verrichtungIndividuellID)
        if ('' !== ($verrichtungIndividuellIDChoiceErrorMessage = self::validateVerrichtungIndividuellIDForChoiceConstraintsFromSetVerrichtungIndividuellID($verrichtungIndividuellID))) {
            throw new \InvalidArgumentException($verrichtungIndividuellIDChoiceErrorMessage, __LINE__);
        }
        if (is_null($verrichtungIndividuellID) || (is_array($verrichtungIndividuellID) && empty($verrichtungIndividuellID))) {
            unset($this->verrichtungIndividuellID);
        } else {
            $this->verrichtungIndividuellID = $verrichtungIndividuellID;
        }
        return $this;
    }
}
