<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeistungsstrukturObjektMitVerrichtung StructType
 * Meta information extracted from the WSDL
 * - documentation: Zur Abbildung von Leistungsobjekten mit Verrichtung nach Leika. Beispiel: "Personalausweis Ausstellung"
 * @subpackage Structs
 */
class LeistungsstrukturObjektMitVerrichtung extends LeistungsstrukturObjekt
{
    /**
     * The leistungsobjektID
     * Meta information extracted from the WSDL
     * - documentation: ID des zugeordneten Leistungsobjekts (Basis).
     * @var \StructType\Identifikator
     */
    public $leistungsobjektID;
    /**
     * The verrichtung
     * Meta information extracted from the WSDL
     * - documentation: Anagbe der Verrichtung.
     * @var \StructType\LeistungsverrichtungAuswahl
     */
    public $verrichtung;
    /**
     * Constructor method for LeistungsstrukturObjektMitVerrichtung
     * @uses LeistungsstrukturObjektMitVerrichtung::setLeistungsobjektID()
     * @uses LeistungsstrukturObjektMitVerrichtung::setVerrichtung()
     * @param \StructType\Identifikator $leistungsobjektID
     * @param \StructType\LeistungsverrichtungAuswahl $verrichtung
     */
    public function __construct(\StructType\Identifikator $leistungsobjektID = null, \StructType\LeistungsverrichtungAuswahl $verrichtung = null)
    {
        $this
            ->setLeistungsobjektID($leistungsobjektID)
            ->setVerrichtung($verrichtung);
    }
    /**
     * Get leistungsobjektID value
     * @return \StructType\Identifikator|null
     */
    public function getLeistungsobjektID()
    {
        return $this->leistungsobjektID;
    }
    /**
     * Set leistungsobjektID value
     * @param \StructType\Identifikator $leistungsobjektID
     * @return \StructType\LeistungsstrukturObjektMitVerrichtung
     */
    public function setLeistungsobjektID(\StructType\Identifikator $leistungsobjektID = null)
    {
        $this->leistungsobjektID = $leistungsobjektID;
        return $this;
    }
    /**
     * Get verrichtung value
     * @return \StructType\LeistungsverrichtungAuswahl|null
     */
    public function getVerrichtung()
    {
        return $this->verrichtung;
    }
    /**
     * Set verrichtung value
     * @param \StructType\LeistungsverrichtungAuswahl $verrichtung
     * @return \StructType\LeistungsstrukturObjektMitVerrichtung
     */
    public function setVerrichtung(\StructType\LeistungsverrichtungAuswahl $verrichtung = null)
    {
        $this->verrichtung = $verrichtung;
        return $this;
    }
}
