<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeistungsmodulSpezialisierung StructType
 * Meta information extracted from the WSDL
 * - documentation: Dient der Abbildung der Spezialisierung, d.h. dem Ergänzen oder Ersetzen von Leistungsmodulen innerhalb der Verwaltungsebenen.
 * @subpackage Structs
 */
class LeistungsmodulSpezialisierung extends AbstractStructBase
{
    /**
     * The modul
     * Meta information extracted from the WSDL
     * - documentation: Der Inhalt des spezialisierten Moduls. Es kann jede Ableitung von Leistungsmodul verwendet werden. Das Weglassen dieses Elements darf nur in Kombination mit ersetzung = true verwendet werden. Dies bedeutet, dass das übergeordnete
     * Modul quasi entfernt wird. Es ist darauf zu achten, ein Modul mit strukturierten Daten (Kosten, Fristen, etc) nur einmal zu verwenden. Textmodule dürfen nur einmal pro Textmodultyp verwendet werden.
     * - minOccurs: 0
     * @var \StructType\Leistungsmodul
     */
    public $modul;
    /**
     * The ersetzung
     * Meta information extracted from the WSDL
     * - documentation: Wird dieses Kennzeichen auf true gesetzt, wird der Inhalt des übergeordneten Leistungsmoduls bzw. der übergeordneten Spezialisierung ersetzt. Übergeordnet meint hier die Position innerhalb Verwaltungs- bzw. Gebietshierarchie, d.h.
     * der Angabe von LeistungSpezialisierung.gueltigkeitGebietID. Per Standard wird dieser ergänzt.
     * - default: false
     * @var bool
     */
    public $ersetzung;
    /**
     * Constructor method for LeistungsmodulSpezialisierung
     * @uses LeistungsmodulSpezialisierung::setModul()
     * @uses LeistungsmodulSpezialisierung::setErsetzung()
     * @param \StructType\Leistungsmodul $modul
     * @param bool $ersetzung
     */
    public function __construct(\StructType\Leistungsmodul $modul = null, $ersetzung = false)
    {
        $this
            ->setModul($modul)
            ->setErsetzung($ersetzung);
    }
    /**
     * Get modul value
     * @return \StructType\Leistungsmodul|null
     */
    public function getModul()
    {
        return $this->modul;
    }
    /**
     * Set modul value
     * @param \StructType\Leistungsmodul $modul
     * @return \StructType\LeistungsmodulSpezialisierung
     */
    public function setModul(\StructType\Leistungsmodul $modul = null)
    {
        $this->modul = $modul;
        return $this;
    }
    /**
     * Get ersetzung value
     * @return bool|null
     */
    public function getErsetzung()
    {
        return $this->ersetzung;
    }
    /**
     * Set ersetzung value
     * @param bool $ersetzung
     * @return \StructType\LeistungsmodulSpezialisierung
     */
    public function setErsetzung($ersetzung = false)
    {
        // validation for constraint: boolean
        if (!is_null($ersetzung) && !is_bool($ersetzung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ersetzung, true), gettype($ersetzung)), __LINE__);
        }
        $this->ersetzung = $ersetzung;
        return $this;
    }
}
