<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Leistungsmodul StructType
 * Meta information extracted from the WSDL
 * - documentation: Abstrakte Klasse zur Abbildung von inhaltlichen Modulen einer Leistung. Es müssen die konkreten Ableitungen verwendet werden.
 * @subpackage Structs
 */
abstract class Leistungsmodul extends AbstractStructBase
{
    /**
     * The positionDarstellung
     * Meta information extracted from the WSDL
     * - documentation: Position in der Darstellung aller Module einer Leistung.
     * - minOccurs: 0
     * @var int
     */
    public $positionDarstellung;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Optionale primäre ID.
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * Meta information extracted from the WSDL
     * - documentation: Sekündäre IDs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idSekundaer;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for Leistungsmodul
     * @uses Leistungsmodul::setPositionDarstellung()
     * @uses Leistungsmodul::setId()
     * @uses Leistungsmodul::setIdSekundaer()
     * @uses Leistungsmodul::setGueltigkeit()
     * @param int $positionDarstellung
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator[] $idSekundaer
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct($positionDarstellung = null, \StructType\Identifikator $id = null, array $idSekundaer = array(), array $gueltigkeit = array())
    {
        $this
            ->setPositionDarstellung($positionDarstellung)
            ->setId($id)
            ->setIdSekundaer($idSekundaer)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get positionDarstellung value
     * @return int|null
     */
    public function getPositionDarstellung()
    {
        return $this->positionDarstellung;
    }
    /**
     * Set positionDarstellung value
     * @param int $positionDarstellung
     * @return \StructType\Leistungsmodul
     */
    public function setPositionDarstellung($positionDarstellung = null)
    {
        // validation for constraint: int
        if (!is_null($positionDarstellung) && !(is_int($positionDarstellung) || ctype_digit($positionDarstellung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($positionDarstellung, true), gettype($positionDarstellung)), __LINE__);
        }
        $this->positionDarstellung = $positionDarstellung;
        return $this;
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Leistungsmodul
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSekundaer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSekundaer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSekundaerForArrayConstraintsFromSetIdSekundaer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungsmodulIdSekundaerItem) {
            // validation for constraint: itemType
            if (!$leistungsmodulIdSekundaerItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($leistungsmodulIdSekundaerItem) ? get_class($leistungsmodulIdSekundaerItem) : sprintf('%s(%s)', gettype($leistungsmodulIdSekundaerItem), var_export($leistungsmodulIdSekundaerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idSekundaer
     * @return \StructType\Leistungsmodul
     */
    public function setIdSekundaer(array $idSekundaer = array())
    {
        // validation for constraint: array
        if ('' !== ($idSekundaerArrayErrorMessage = self::validateIdSekundaerForArrayConstraintsFromSetIdSekundaer($idSekundaer))) {
            throw new \InvalidArgumentException($idSekundaerArrayErrorMessage, __LINE__);
        }
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Add item to idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Leistungsmodul
     */
    public function addToIdSekundaer(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSekundaer[] = $item;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungsmodulGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$leistungsmodulGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($leistungsmodulGueltigkeitItem) ? get_class($leistungsmodulGueltigkeitItem) : sprintf('%s(%s)', gettype($leistungsmodulGueltigkeitItem), var_export($leistungsmodulGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Leistungsmodul
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Leistungsmodul
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
