<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Leistungskategorie StructType
 * Meta information extracted from the WSDL
 * - documentation: Gruppe zur Abbildung von Elementen von Kategorien. | Eine Leistungskategorie dient zur Kategorisierung/Gruppierung von Leistungen. Kategorien können in Klassen unterteilt werden, um z.B. ein Lebenslagenmodell sowie ein internes
 * Organisationsmodell abzubilden. Es können somit weitere Ordnungsrahmen verwendet werden.
 * @subpackage Structs
 */
class Leistungskategorie extends AbstractStructBase
{
    /**
     * The klasse
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Leistungskategorieklasse.
     * @var \StructType\LeistungskategorieKlasse
     */
    public $klasse;
    /**
     * The id
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * @var \StructType\Identifikator
     */
    public $idSekundaer;
    /**
     * The uebergeordneteKategorieID
     * @var \StructType\Identifikator
     */
    public $uebergeordneteKategorieID;
    /**
     * The untergeordneteKategorieID
     * @var \StructType\Identifikator
     */
    public $untergeordneteKategorieID;
    /**
     * The bezeichnung
     * @var \StructType\String_Localized
     */
    public $bezeichnung;
    /**
     * The beschreibung
     * @var \StructType\String_Localized
     */
    public $beschreibung;
    /**
     * Constructor method for Leistungskategorie
     * @uses Leistungskategorie::setKlasse()
     * @uses Leistungskategorie::setId()
     * @uses Leistungskategorie::setIdSekundaer()
     * @uses Leistungskategorie::setUebergeordneteKategorieID()
     * @uses Leistungskategorie::setUntergeordneteKategorieID()
     * @uses Leistungskategorie::setBezeichnung()
     * @uses Leistungskategorie::setBeschreibung()
     * @param \StructType\LeistungskategorieKlasse $klasse
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator $idSekundaer
     * @param \StructType\Identifikator $uebergeordneteKategorieID
     * @param \StructType\Identifikator $untergeordneteKategorieID
     * @param \StructType\String_Localized $bezeichnung
     * @param \StructType\String_Localized $beschreibung
     */
    public function __construct(\StructType\LeistungskategorieKlasse $klasse = null, \StructType\Identifikator $id = null, \StructType\Identifikator $idSekundaer = null, \StructType\Identifikator $uebergeordneteKategorieID = null, \StructType\Identifikator $untergeordneteKategorieID = null, \StructType\String_Localized $bezeichnung = null, \StructType\String_Localized $beschreibung = null)
    {
        $this
            ->setKlasse($klasse)
            ->setId($id)
            ->setIdSekundaer($idSekundaer)
            ->setUebergeordneteKategorieID($uebergeordneteKategorieID)
            ->setUntergeordneteKategorieID($untergeordneteKategorieID)
            ->setBezeichnung($bezeichnung)
            ->setBeschreibung($beschreibung);
    }
    /**
     * Get klasse value
     * @return \StructType\LeistungskategorieKlasse|null
     */
    public function getKlasse()
    {
        return $this->klasse;
    }
    /**
     * Set klasse value
     * @param \StructType\LeistungskategorieKlasse $klasse
     * @return \StructType\Leistungskategorie
     */
    public function setKlasse(\StructType\LeistungskategorieKlasse $klasse = null)
    {
        $this->klasse = $klasse;
        return $this;
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Leistungskategorie
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * Set idSekundaer value
     * @param \StructType\Identifikator $idSekundaer
     * @return \StructType\Leistungskategorie
     */
    public function setIdSekundaer(\StructType\Identifikator $idSekundaer = null)
    {
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Get uebergeordneteKategorieID value
     * @return \StructType\Identifikator|null
     */
    public function getUebergeordneteKategorieID()
    {
        return $this->uebergeordneteKategorieID;
    }
    /**
     * Set uebergeordneteKategorieID value
     * @param \StructType\Identifikator $uebergeordneteKategorieID
     * @return \StructType\Leistungskategorie
     */
    public function setUebergeordneteKategorieID(\StructType\Identifikator $uebergeordneteKategorieID = null)
    {
        $this->uebergeordneteKategorieID = $uebergeordneteKategorieID;
        return $this;
    }
    /**
     * Get untergeordneteKategorieID value
     * @return \StructType\Identifikator|null
     */
    public function getUntergeordneteKategorieID()
    {
        return $this->untergeordneteKategorieID;
    }
    /**
     * Set untergeordneteKategorieID value
     * @param \StructType\Identifikator $untergeordneteKategorieID
     * @return \StructType\Leistungskategorie
     */
    public function setUntergeordneteKategorieID(\StructType\Identifikator $untergeordneteKategorieID = null)
    {
        $this->untergeordneteKategorieID = $untergeordneteKategorieID;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return \StructType\String_Localized|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param \StructType\String_Localized $bezeichnung
     * @return \StructType\Leistungskategorie
     */
    public function setBezeichnung(\StructType\String_Localized $bezeichnung = null)
    {
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * Set beschreibung value
     * @param \StructType\String_Localized $beschreibung
     * @return \StructType\Leistungskategorie
     */
    public function setBeschreibung(\StructType\String_Localized $beschreibung = null)
    {
        $this->beschreibung = $beschreibung;
        return $this;
    }
}
