<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeistungsgruppierungAuswahl StructType
 * Meta information extracted from the WSDL
 * - documentation: Auswahl der Gruppierung - entweder die Gruppierungnach LeiKa oder die Angabe einer individuellen Gruppierung.
 * @subpackage Structs
 */
class LeistungsgruppierungAuswahl extends AbstractStructBase
{
    /**
     * The leistungsgruppierungLeiKa
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Leistungsgruppierung nach LeiKa
     * - choice: leistungsgruppierungLeiKa | leistungsgruppierungIndividuell
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Code_LeiKaLeistungsgruppierung
     */
    public $leistungsgruppierungLeiKa;
    /**
     * The leistungsgruppierungIndividuell
     * Meta information extracted from the WSDL
     * - documentation: Individuelle Gruppierung. Realisiert durch Leistungskategorie mit entsprechender Klasse.
     * - choice: leistungsgruppierungLeiKa | leistungsgruppierungIndividuell
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Leistungskategorie
     */
    public $leistungsgruppierungIndividuell;
    /**
     * Constructor method for LeistungsgruppierungAuswahl
     * @uses LeistungsgruppierungAuswahl::setLeistungsgruppierungLeiKa()
     * @uses LeistungsgruppierungAuswahl::setLeistungsgruppierungIndividuell()
     * @param \StructType\Code_LeiKaLeistungsgruppierung $leistungsgruppierungLeiKa
     * @param \StructType\Leistungskategorie $leistungsgruppierungIndividuell
     */
    public function __construct(\StructType\Code_LeiKaLeistungsgruppierung $leistungsgruppierungLeiKa = null, \StructType\Leistungskategorie $leistungsgruppierungIndividuell = null)
    {
        $this
            ->setLeistungsgruppierungLeiKa($leistungsgruppierungLeiKa)
            ->setLeistungsgruppierungIndividuell($leistungsgruppierungIndividuell);
    }
    /**
     * Get leistungsgruppierungLeiKa value
     * @return \StructType\Code_LeiKaLeistungsgruppierung|null
     */
    public function getLeistungsgruppierungLeiKa()
    {
        return isset($this->leistungsgruppierungLeiKa) ? $this->leistungsgruppierungLeiKa : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLeistungsgruppierungLeiKa method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistungsgruppierungLeiKa method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLeistungsgruppierungLeiKaForChoiceConstraintsFromSetLeistungsgruppierungLeiKa($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'leistungsgruppierungIndividuell',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property leistungsgruppierungLeiKa can\'t be set as the property %s is already set. Only one property must be set among these properties: leistungsgruppierungLeiKa, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set leistungsgruppierungLeiKa value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Code_LeiKaLeistungsgruppierung $leistungsgruppierungLeiKa
     * @return \StructType\LeistungsgruppierungAuswahl
     */
    public function setLeistungsgruppierungLeiKa(\StructType\Code_LeiKaLeistungsgruppierung $leistungsgruppierungLeiKa = null)
    {
        // validation for constraint: choice(leistungsgruppierungLeiKa, leistungsgruppierungIndividuell)
        if ('' !== ($leistungsgruppierungLeiKaChoiceErrorMessage = self::validateLeistungsgruppierungLeiKaForChoiceConstraintsFromSetLeistungsgruppierungLeiKa($leistungsgruppierungLeiKa))) {
            throw new \InvalidArgumentException($leistungsgruppierungLeiKaChoiceErrorMessage, __LINE__);
        }
        if (is_null($leistungsgruppierungLeiKa) || (is_array($leistungsgruppierungLeiKa) && empty($leistungsgruppierungLeiKa))) {
            unset($this->leistungsgruppierungLeiKa);
        } else {
            $this->leistungsgruppierungLeiKa = $leistungsgruppierungLeiKa;
        }
        return $this;
    }
    /**
     * Get leistungsgruppierungIndividuell value
     * @return \StructType\Leistungskategorie|null
     */
    public function getLeistungsgruppierungIndividuell()
    {
        return isset($this->leistungsgruppierungIndividuell) ? $this->leistungsgruppierungIndividuell : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLeistungsgruppierungIndividuell method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistungsgruppierungIndividuell method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLeistungsgruppierungIndividuellForChoiceConstraintsFromSetLeistungsgruppierungIndividuell($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'leistungsgruppierungLeiKa',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property leistungsgruppierungIndividuell can\'t be set as the property %s is already set. Only one property must be set among these properties: leistungsgruppierungIndividuell, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set leistungsgruppierungIndividuell value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Leistungskategorie $leistungsgruppierungIndividuell
     * @return \StructType\LeistungsgruppierungAuswahl
     */
    public function setLeistungsgruppierungIndividuell(\StructType\Leistungskategorie $leistungsgruppierungIndividuell = null)
    {
        // validation for constraint: choice(leistungsgruppierungLeiKa, leistungsgruppierungIndividuell)
        if ('' !== ($leistungsgruppierungIndividuellChoiceErrorMessage = self::validateLeistungsgruppierungIndividuellForChoiceConstraintsFromSetLeistungsgruppierungIndividuell($leistungsgruppierungIndividuell))) {
            throw new \InvalidArgumentException($leistungsgruppierungIndividuellChoiceErrorMessage, __LINE__);
        }
        if (is_null($leistungsgruppierungIndividuell) || (is_array($leistungsgruppierungIndividuell) && empty($leistungsgruppierungIndividuell))) {
            unset($this->leistungsgruppierungIndividuell);
        } else {
            $this->leistungsgruppierungIndividuell = $leistungsgruppierungIndividuell;
        }
        return $this;
    }
}
