<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LanguageCode_PropertyType StructType
 * @subpackage Structs
 */
class LanguageCode_PropertyType extends AbstractStructBase
{
    /**
     * The LanguageCode
     * @var \StructType\CodeListValue_Type
     */
    public $LanguageCode;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for LanguageCode_PropertyType
     * @uses LanguageCode_PropertyType::setLanguageCode()
     * @uses LanguageCode_PropertyType::setNilReason()
     * @param \StructType\CodeListValue_Type $languageCode
     * @param string $nilReason
     */
    public function __construct(\StructType\CodeListValue_Type $languageCode = null, $nilReason = null)
    {
        $this
            ->setLanguageCode($languageCode)
            ->setNilReason($nilReason);
    }
    /**
     * Get LanguageCode value
     * @return \StructType\CodeListValue_Type|null
     */
    public function getLanguageCode()
    {
        return $this->LanguageCode;
    }
    /**
     * Set LanguageCode value
     * @param \StructType\CodeListValue_Type $languageCode
     * @return \StructType\LanguageCode_PropertyType
     */
    public function setLanguageCode(\StructType\CodeListValue_Type $languageCode = null)
    {
        $this->LanguageCode = $languageCode;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\LanguageCode_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
