<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KostenVariabel StructType
 * Meta information extracted from the WSDL
 * - documentation: Zur Abbildung variabler Kosten mit Unter- und Obergrenze.
 * @subpackage Structs
 */
class KostenVariabel extends AbstractStructBase
{
    /**
     * The betragUntergrenze
     * Meta information extracted from the WSDL
     * - documentation: Betrag als Untergrenze.
     * - minOccurs: 0
     * @var \StructType\Amount
     */
    public $betragUntergrenze;
    /**
     * The betragObergrenze
     * Meta information extracted from the WSDL
     * - documentation: Betrag als Obergrenze.
     * - minOccurs: 0
     * @var \StructType\Amount
     */
    public $betragObergrenze;
    /**
     * The beschreibungVariabilitaet
     * Meta information extracted from the WSDL
     * - documentation: Begründung oder Beschreibung der Kostenvariabilität als Text.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibungVariabilitaet;
    /**
     * Constructor method for KostenVariabel
     * @uses KostenVariabel::setBetragUntergrenze()
     * @uses KostenVariabel::setBetragObergrenze()
     * @uses KostenVariabel::setBeschreibungVariabilitaet()
     * @param \StructType\Amount $betragUntergrenze
     * @param \StructType\Amount $betragObergrenze
     * @param \StructType\String_Localized[] $beschreibungVariabilitaet
     */
    public function __construct(\StructType\Amount $betragUntergrenze = null, \StructType\Amount $betragObergrenze = null, array $beschreibungVariabilitaet = array())
    {
        $this
            ->setBetragUntergrenze($betragUntergrenze)
            ->setBetragObergrenze($betragObergrenze)
            ->setBeschreibungVariabilitaet($beschreibungVariabilitaet);
    }
    /**
     * Get betragUntergrenze value
     * @return \StructType\Amount|null
     */
    public function getBetragUntergrenze()
    {
        return $this->betragUntergrenze;
    }
    /**
     * Set betragUntergrenze value
     * @param \StructType\Amount $betragUntergrenze
     * @return \StructType\KostenVariabel
     */
    public function setBetragUntergrenze(\StructType\Amount $betragUntergrenze = null)
    {
        $this->betragUntergrenze = $betragUntergrenze;
        return $this;
    }
    /**
     * Get betragObergrenze value
     * @return \StructType\Amount|null
     */
    public function getBetragObergrenze()
    {
        return $this->betragObergrenze;
    }
    /**
     * Set betragObergrenze value
     * @param \StructType\Amount $betragObergrenze
     * @return \StructType\KostenVariabel
     */
    public function setBetragObergrenze(\StructType\Amount $betragObergrenze = null)
    {
        $this->betragObergrenze = $betragObergrenze;
        return $this;
    }
    /**
     * Get beschreibungVariabilitaet value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibungVariabilitaet()
    {
        return $this->beschreibungVariabilitaet;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibungVariabilitaet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibungVariabilitaet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungVariabilitaetForArrayConstraintsFromSetBeschreibungVariabilitaet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kostenVariabelBeschreibungVariabilitaetItem) {
            // validation for constraint: itemType
            if (!$kostenVariabelBeschreibungVariabilitaetItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($kostenVariabelBeschreibungVariabilitaetItem) ? get_class($kostenVariabelBeschreibungVariabilitaetItem) : sprintf('%s(%s)', gettype($kostenVariabelBeschreibungVariabilitaetItem), var_export($kostenVariabelBeschreibungVariabilitaetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibungVariabilitaet property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibungVariabilitaet value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibungVariabilitaet
     * @return \StructType\KostenVariabel
     */
    public function setBeschreibungVariabilitaet(array $beschreibungVariabilitaet = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungVariabilitaetArrayErrorMessage = self::validateBeschreibungVariabilitaetForArrayConstraintsFromSetBeschreibungVariabilitaet($beschreibungVariabilitaet))) {
            throw new \InvalidArgumentException($beschreibungVariabilitaetArrayErrorMessage, __LINE__);
        }
        $this->beschreibungVariabilitaet = $beschreibungVariabilitaet;
        return $this;
    }
    /**
     * Add item to beschreibungVariabilitaet value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\KostenVariabel
     */
    public function addToBeschreibungVariabilitaet(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibungVariabilitaet property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibungVariabilitaet[] = $item;
        return $this;
    }
}
