<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KostenFrei StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp für Angabe, dass keine Kosten anfallen.
 * @subpackage Structs
 */
class KostenFrei extends AbstractStructBase
{
    /**
     * The beschreibungKostenfreiheit
     * Meta information extracted from the WSDL
     * - documentation: Begründung oder Voraussetzung der Kostenfreiheit als Text.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibungKostenfreiheit;
    /**
     * Constructor method for KostenFrei
     * @uses KostenFrei::setBeschreibungKostenfreiheit()
     * @param \StructType\String_Localized[] $beschreibungKostenfreiheit
     */
    public function __construct(array $beschreibungKostenfreiheit = array())
    {
        $this
            ->setBeschreibungKostenfreiheit($beschreibungKostenfreiheit);
    }
    /**
     * Get beschreibungKostenfreiheit value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibungKostenfreiheit()
    {
        return $this->beschreibungKostenfreiheit;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibungKostenfreiheit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibungKostenfreiheit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungKostenfreiheitForArrayConstraintsFromSetBeschreibungKostenfreiheit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kostenFreiBeschreibungKostenfreiheitItem) {
            // validation for constraint: itemType
            if (!$kostenFreiBeschreibungKostenfreiheitItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($kostenFreiBeschreibungKostenfreiheitItem) ? get_class($kostenFreiBeschreibungKostenfreiheitItem) : sprintf('%s(%s)', gettype($kostenFreiBeschreibungKostenfreiheitItem), var_export($kostenFreiBeschreibungKostenfreiheitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibungKostenfreiheit property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibungKostenfreiheit value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibungKostenfreiheit
     * @return \StructType\KostenFrei
     */
    public function setBeschreibungKostenfreiheit(array $beschreibungKostenfreiheit = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungKostenfreiheitArrayErrorMessage = self::validateBeschreibungKostenfreiheitForArrayConstraintsFromSetBeschreibungKostenfreiheit($beschreibungKostenfreiheit))) {
            throw new \InvalidArgumentException($beschreibungKostenfreiheitArrayErrorMessage, __LINE__);
        }
        $this->beschreibungKostenfreiheit = $beschreibungKostenfreiheit;
        return $this;
    }
    /**
     * Add item to beschreibungKostenfreiheit value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\KostenFrei
     */
    public function addToBeschreibungKostenfreiheit(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibungKostenfreiheit property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibungKostenfreiheit[] = $item;
        return $this;
    }
}
