<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Kosten StructType
 * Meta information extracted from the WSDL
 * - documentation: Dient zur Abbildung für Kosten, z.B. Gebühren, von Leistungen.
 * @subpackage Structs
 */
class Kosten extends AbstractStructBase
{
    /**
     * The typ
     * Meta information extracted from the WSDL
     * - documentation: Zugeordneter Kostentyp.
     * @var \StructType\KostenTyp_Erweiterbar
     */
    public $typ;
    /**
     * The kostenauswahl
     * Meta information extracted from the WSDL
     * - documentation: Die eigentlichen Kosten.
     * @var \StructType\Kostenauswahl
     */
    public $kostenauswahl;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Erläuterungen zu Kosten.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The vorkasse
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob Kosten in Vorkasse zu entrichten sind.
     * - minOccurs: 0
     * @var bool
     */
    public $vorkasse;
    /**
     * The linkKostenbildung
     * Meta information extracted from the WSDL
     * - documentation: Link zur URL, wo Kostenbildung näher erläutert oder berechnet wird.
     * - minOccurs: 0
     * @var string
     */
    public $linkKostenbildung;
    /**
     * The positionDarstellung
     * Meta information extracted from the WSDL
     * - documentation: Position in der Darstellung aller Kosten pro Leistung.
     * - minOccurs: 0
     * @var int
     */
    public $positionDarstellung;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for Kosten
     * @uses Kosten::setTyp()
     * @uses Kosten::setKostenauswahl()
     * @uses Kosten::setBeschreibung()
     * @uses Kosten::setVorkasse()
     * @uses Kosten::setLinkKostenbildung()
     * @uses Kosten::setPositionDarstellung()
     * @uses Kosten::setGueltigkeit()
     * @param \StructType\KostenTyp_Erweiterbar $typ
     * @param \StructType\Kostenauswahl $kostenauswahl
     * @param \StructType\String_Localized[] $beschreibung
     * @param bool $vorkasse
     * @param string $linkKostenbildung
     * @param int $positionDarstellung
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(\StructType\KostenTyp_Erweiterbar $typ = null, \StructType\Kostenauswahl $kostenauswahl = null, array $beschreibung = array(), $vorkasse = null, $linkKostenbildung = null, $positionDarstellung = null, array $gueltigkeit = array())
    {
        $this
            ->setTyp($typ)
            ->setKostenauswahl($kostenauswahl)
            ->setBeschreibung($beschreibung)
            ->setVorkasse($vorkasse)
            ->setLinkKostenbildung($linkKostenbildung)
            ->setPositionDarstellung($positionDarstellung)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get typ value
     * @return \StructType\KostenTyp_Erweiterbar|null
     */
    public function getTyp()
    {
        return $this->typ;
    }
    /**
     * Set typ value
     * @param \StructType\KostenTyp_Erweiterbar $typ
     * @return \StructType\Kosten
     */
    public function setTyp(\StructType\KostenTyp_Erweiterbar $typ = null)
    {
        $this->typ = $typ;
        return $this;
    }
    /**
     * Get kostenauswahl value
     * @return \StructType\Kostenauswahl|null
     */
    public function getKostenauswahl()
    {
        return $this->kostenauswahl;
    }
    /**
     * Set kostenauswahl value
     * @param \StructType\Kostenauswahl $kostenauswahl
     * @return \StructType\Kosten
     */
    public function setKostenauswahl(\StructType\Kostenauswahl $kostenauswahl = null)
    {
        $this->kostenauswahl = $kostenauswahl;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kostenBeschreibungItem) {
            // validation for constraint: itemType
            if (!$kostenBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($kostenBeschreibungItem) ? get_class($kostenBeschreibungItem) : sprintf('%s(%s)', gettype($kostenBeschreibungItem), var_export($kostenBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Kosten
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Kosten
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get vorkasse value
     * @return bool|null
     */
    public function getVorkasse()
    {
        return $this->vorkasse;
    }
    /**
     * Set vorkasse value
     * @param bool $vorkasse
     * @return \StructType\Kosten
     */
    public function setVorkasse($vorkasse = null)
    {
        // validation for constraint: boolean
        if (!is_null($vorkasse) && !is_bool($vorkasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($vorkasse, true), gettype($vorkasse)), __LINE__);
        }
        $this->vorkasse = $vorkasse;
        return $this;
    }
    /**
     * Get linkKostenbildung value
     * @return string|null
     */
    public function getLinkKostenbildung()
    {
        return $this->linkKostenbildung;
    }
    /**
     * Set linkKostenbildung value
     * @param string $linkKostenbildung
     * @return \StructType\Kosten
     */
    public function setLinkKostenbildung($linkKostenbildung = null)
    {
        // validation for constraint: string
        if (!is_null($linkKostenbildung) && !is_string($linkKostenbildung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkKostenbildung, true), gettype($linkKostenbildung)), __LINE__);
        }
        $this->linkKostenbildung = $linkKostenbildung;
        return $this;
    }
    /**
     * Get positionDarstellung value
     * @return int|null
     */
    public function getPositionDarstellung()
    {
        return $this->positionDarstellung;
    }
    /**
     * Set positionDarstellung value
     * @param int $positionDarstellung
     * @return \StructType\Kosten
     */
    public function setPositionDarstellung($positionDarstellung = null)
    {
        // validation for constraint: int
        if (!is_null($positionDarstellung) && !(is_int($positionDarstellung) || ctype_digit($positionDarstellung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($positionDarstellung, true), gettype($positionDarstellung)), __LINE__);
        }
        $this->positionDarstellung = $positionDarstellung;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kostenGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$kostenGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($kostenGueltigkeitItem) ? get_class($kostenGueltigkeitItem) : sprintf('%s(%s)', gettype($kostenGueltigkeitItem), var_export($kostenGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Kosten
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Kosten
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
