<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Kategorieklasse StructType
 * Meta information extracted from the WSDL
 * - documentation: Abstrakte Klasse zur Klassifikation von Kategorien.
 * @subpackage Structs
 */
abstract class Kategorieklasse extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Primäre ID.
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * Meta information extracted from the WSDL
     * - documentation: Sekundäre IDs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idSekundaer;
    /**
     * The bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung der Klasse.
     * - maxOccurs: unbounded
     * @var \StructType\String_Localized[]
     */
    public $bezeichnung;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Allgemeine Beschreibung der Klasse.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - documentation: Optionale Angabe einer Versionsnummer der Klassifizierung.
     * - minOccurs: 0
     * @var string
     */
    public $version;
    /**
     * Constructor method for Kategorieklasse
     * @uses Kategorieklasse::setId()
     * @uses Kategorieklasse::setIdSekundaer()
     * @uses Kategorieklasse::setBezeichnung()
     * @uses Kategorieklasse::setBeschreibung()
     * @uses Kategorieklasse::setVersion()
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator[] $idSekundaer
     * @param \StructType\String_Localized[] $bezeichnung
     * @param \StructType\String_Localized[] $beschreibung
     * @param string $version
     */
    public function __construct(\StructType\Identifikator $id = null, array $idSekundaer = array(), array $bezeichnung = array(), array $beschreibung = array(), $version = null)
    {
        $this
            ->setId($id)
            ->setIdSekundaer($idSekundaer)
            ->setBezeichnung($bezeichnung)
            ->setBeschreibung($beschreibung)
            ->setVersion($version);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Kategorieklasse
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSekundaer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSekundaer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSekundaerForArrayConstraintsFromSetIdSekundaer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kategorieklasseIdSekundaerItem) {
            // validation for constraint: itemType
            if (!$kategorieklasseIdSekundaerItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($kategorieklasseIdSekundaerItem) ? get_class($kategorieklasseIdSekundaerItem) : sprintf('%s(%s)', gettype($kategorieklasseIdSekundaerItem), var_export($kategorieklasseIdSekundaerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idSekundaer
     * @return \StructType\Kategorieklasse
     */
    public function setIdSekundaer(array $idSekundaer = array())
    {
        // validation for constraint: array
        if ('' !== ($idSekundaerArrayErrorMessage = self::validateIdSekundaerForArrayConstraintsFromSetIdSekundaer($idSekundaer))) {
            throw new \InvalidArgumentException($idSekundaerArrayErrorMessage, __LINE__);
        }
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Add item to idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Kategorieklasse
     */
    public function addToIdSekundaer(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSekundaer[] = $item;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setBezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBezeichnungForArrayConstraintsFromSetBezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kategorieklasseBezeichnungItem) {
            // validation for constraint: itemType
            if (!$kategorieklasseBezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($kategorieklasseBezeichnungItem) ? get_class($kategorieklasseBezeichnungItem) : sprintf('%s(%s)', gettype($kategorieklasseBezeichnungItem), var_export($kategorieklasseBezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $bezeichnung
     * @return \StructType\Kategorieklasse
     */
    public function setBezeichnung(array $bezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($bezeichnungArrayErrorMessage = self::validateBezeichnungForArrayConstraintsFromSetBezeichnung($bezeichnung))) {
            throw new \InvalidArgumentException($bezeichnungArrayErrorMessage, __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Add item to bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Kategorieklasse
     */
    public function addToBezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bezeichnung[] = $item;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kategorieklasseBeschreibungItem) {
            // validation for constraint: itemType
            if (!$kategorieklasseBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($kategorieklasseBeschreibungItem) ? get_class($kategorieklasseBeschreibungItem) : sprintf('%s(%s)', gettype($kategorieklasseBeschreibungItem), var_export($kategorieklasseBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Kategorieklasse
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Kategorieklasse
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Kategorieklasse
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
