<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Integer_PropertyType StructType
 * @subpackage Structs
 */
class Integer_PropertyType extends AbstractStructBase
{
    /**
     * The Integer
     * @var int
     */
    public $Integer;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for Integer_PropertyType
     * @uses Integer_PropertyType::setInteger()
     * @uses Integer_PropertyType::setNilReason()
     * @param int $integer
     * @param string $nilReason
     */
    public function __construct($integer = null, $nilReason = null)
    {
        $this
            ->setInteger($integer)
            ->setNilReason($nilReason);
    }
    /**
     * Get Integer value
     * @return int|null
     */
    public function getInteger()
    {
        return $this->Integer;
    }
    /**
     * Set Integer value
     * @param int $integer
     * @return \StructType\Integer_PropertyType
     */
    public function setInteger($integer = null)
    {
        // validation for constraint: int
        if (!is_null($integer) && !(is_int($integer) || ctype_digit($integer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($integer, true), gettype($integer)), __LINE__);
        }
        $this->Integer = $integer;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\Integer_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
