<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImageCRSType StructType
 * @subpackage Structs
 */
class ImageCRSType extends AbstractStructBase
{
    /**
     * The cartesianCS
     * @var \StructType\CartesianCSPropertyType
     */
    public $cartesianCS;
    /**
     * The affineCS
     * @var \StructType\AffineCSPropertyType
     */
    public $affineCS;
    /**
     * The usesObliqueCartesianCS
     * @var \StructType\ObliqueCartesianCSPropertyType
     */
    public $usesObliqueCartesianCS;
    /**
     * The imageDatum
     * @var \StructType\ImageDatumPropertyType
     */
    public $imageDatum;
    /**
     * Constructor method for ImageCRSType
     * @uses ImageCRSType::setCartesianCS()
     * @uses ImageCRSType::setAffineCS()
     * @uses ImageCRSType::setUsesObliqueCartesianCS()
     * @uses ImageCRSType::setImageDatum()
     * @param \StructType\CartesianCSPropertyType $cartesianCS
     * @param \StructType\AffineCSPropertyType $affineCS
     * @param \StructType\ObliqueCartesianCSPropertyType $usesObliqueCartesianCS
     * @param \StructType\ImageDatumPropertyType $imageDatum
     */
    public function __construct(\StructType\CartesianCSPropertyType $cartesianCS = null, \StructType\AffineCSPropertyType $affineCS = null, \StructType\ObliqueCartesianCSPropertyType $usesObliqueCartesianCS = null, \StructType\ImageDatumPropertyType $imageDatum = null)
    {
        $this
            ->setCartesianCS($cartesianCS)
            ->setAffineCS($affineCS)
            ->setUsesObliqueCartesianCS($usesObliqueCartesianCS)
            ->setImageDatum($imageDatum);
    }
    /**
     * Get cartesianCS value
     * @return \StructType\CartesianCSPropertyType|null
     */
    public function getCartesianCS()
    {
        return $this->cartesianCS;
    }
    /**
     * Set cartesianCS value
     * @param \StructType\CartesianCSPropertyType $cartesianCS
     * @return \StructType\ImageCRSType
     */
    public function setCartesianCS(\StructType\CartesianCSPropertyType $cartesianCS = null)
    {
        $this->cartesianCS = $cartesianCS;
        return $this;
    }
    /**
     * Get affineCS value
     * @return \StructType\AffineCSPropertyType|null
     */
    public function getAffineCS()
    {
        return $this->affineCS;
    }
    /**
     * Set affineCS value
     * @param \StructType\AffineCSPropertyType $affineCS
     * @return \StructType\ImageCRSType
     */
    public function setAffineCS(\StructType\AffineCSPropertyType $affineCS = null)
    {
        $this->affineCS = $affineCS;
        return $this;
    }
    /**
     * Get usesObliqueCartesianCS value
     * @return \StructType\ObliqueCartesianCSPropertyType|null
     */
    public function getUsesObliqueCartesianCS()
    {
        return $this->usesObliqueCartesianCS;
    }
    /**
     * Set usesObliqueCartesianCS value
     * @param \StructType\ObliqueCartesianCSPropertyType $usesObliqueCartesianCS
     * @return \StructType\ImageCRSType
     */
    public function setUsesObliqueCartesianCS(\StructType\ObliqueCartesianCSPropertyType $usesObliqueCartesianCS = null)
    {
        $this->usesObliqueCartesianCS = $usesObliqueCartesianCS;
        return $this;
    }
    /**
     * Get imageDatum value
     * @return \StructType\ImageDatumPropertyType|null
     */
    public function getImageDatum()
    {
        return $this->imageDatum;
    }
    /**
     * Set imageDatum value
     * @param \StructType\ImageDatumPropertyType $imageDatum
     * @return \StructType\ImageCRSType
     */
    public function setImageDatum(\StructType\ImageDatumPropertyType $imageDatum = null)
    {
        $this->imageDatum = $imageDatum;
        return $this;
    }
}
