<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hierarchie StructType
 * Meta information extracted from the WSDL
 * - documentation: Hierarchie ist ein Kernelement zur Darstellung von Netzen. Basis ist ein Quellobjekt, welches die Hierarchiekomponente anbindet. Diesem können beliebig viele Hierarchieobjekte zugeordnet werden. Für jede Zuordnung ist ein
 * Zielobjekt mit seiner Identifikation und Hierarchietyp zu definieren. Der Hierarchietyp orientiert sich an DIN 1463-1.
 * @subpackage Structs
 */
class Hierarchie extends AbstractStructBase
{
    /**
     * The zielID
     * Meta information extracted from the WSDL
     * - documentation: ID des Zielobjekts.
     * @var \StructType\Identifikator
     */
    public $zielID;
    /**
     * The hierarchieTyp
     * Meta information extracted from the WSDL
     * - documentation: Der Typ definiert die Beziehungsart zwischen Quell- und Zielobjekt. Er orientiert sich an DIN 1463-1.
     * @var \StructType\Code_Hierarchietyp
     */
    public $hierarchieTyp;
    /**
     * Constructor method for Hierarchie
     * @uses Hierarchie::setZielID()
     * @uses Hierarchie::setHierarchieTyp()
     * @param \StructType\Identifikator $zielID
     * @param \StructType\Code_Hierarchietyp $hierarchieTyp
     */
    public function __construct(\StructType\Identifikator $zielID = null, \StructType\Code_Hierarchietyp $hierarchieTyp = null)
    {
        $this
            ->setZielID($zielID)
            ->setHierarchieTyp($hierarchieTyp);
    }
    /**
     * Get zielID value
     * @return \StructType\Identifikator|null
     */
    public function getZielID()
    {
        return $this->zielID;
    }
    /**
     * Set zielID value
     * @param \StructType\Identifikator $zielID
     * @return \StructType\Hierarchie
     */
    public function setZielID(\StructType\Identifikator $zielID = null)
    {
        $this->zielID = $zielID;
        return $this;
    }
    /**
     * Get hierarchieTyp value
     * @return \StructType\Code_Hierarchietyp|null
     */
    public function getHierarchieTyp()
    {
        return $this->hierarchieTyp;
    }
    /**
     * Set hierarchieTyp value
     * @param \StructType\Code_Hierarchietyp $hierarchieTyp
     * @return \StructType\Hierarchie
     */
    public function setHierarchieTyp(\StructType\Code_Hierarchietyp $hierarchieTyp = null)
    {
        $this->hierarchieTyp = $hierarchieTyp;
        return $this;
    }
}
