<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Herausgeber StructType
 * Meta information extracted from the WSDL
 * - documentation: Ein Herausgeber ist verantwortlich für die Herausgabe von Inhalten. Dies beinhaltet die Erstellung, Ergänzung oder Zusammenstellung von Daten. Der Herausgeber kann - muss aber nicht - der Urheber der Inhalte sein. Im Kontext XZuFi
 * sind zum Beispiel typische Herausgeber konkrete Gemeinden oder Landkreise.
 * @subpackage Structs
 */
class Herausgeber extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Primäre ID.
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * Meta information extracted from the WSDL
     * - documentation: Sekundäre IDs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idSekundaer;
    /**
     * The bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Die Bezeichnung bzw. der Name, z.B. "Main-Taunus-Kreis"
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $bezeichnung;
    /**
     * The kurzbezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Eine kurze prägnante Bezeichnung, z.B. "MTK".
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $kurzbezeichnung;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Eine textuelle Beschreibung des Herausgebers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The standardZustaendigkeitsgebiet
     * Meta information extracted from the WSDL
     * - documentation: Das typische Zuständigkeitsgebiet des Herausgebers, z.B. das verwaltungspolitische Gebiet eines Kreises.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Gebiet[]
     */
    public $standardZustaendigkeitsgebiet;
    /**
     * Constructor method for Herausgeber
     * @uses Herausgeber::setId()
     * @uses Herausgeber::setIdSekundaer()
     * @uses Herausgeber::setBezeichnung()
     * @uses Herausgeber::setKurzbezeichnung()
     * @uses Herausgeber::setBeschreibung()
     * @uses Herausgeber::setStandardZustaendigkeitsgebiet()
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator[] $idSekundaer
     * @param string[] $bezeichnung
     * @param string[] $kurzbezeichnung
     * @param \StructType\String_Localized[] $beschreibung
     * @param \StructType\Gebiet[] $standardZustaendigkeitsgebiet
     */
    public function __construct(\StructType\Identifikator $id = null, array $idSekundaer = array(), array $bezeichnung = array(), array $kurzbezeichnung = array(), array $beschreibung = array(), array $standardZustaendigkeitsgebiet = array())
    {
        $this
            ->setId($id)
            ->setIdSekundaer($idSekundaer)
            ->setBezeichnung($bezeichnung)
            ->setKurzbezeichnung($kurzbezeichnung)
            ->setBeschreibung($beschreibung)
            ->setStandardZustaendigkeitsgebiet($standardZustaendigkeitsgebiet);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Herausgeber
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSekundaer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSekundaer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSekundaerForArrayConstraintsFromSetIdSekundaer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $herausgeberIdSekundaerItem) {
            // validation for constraint: itemType
            if (!$herausgeberIdSekundaerItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($herausgeberIdSekundaerItem) ? get_class($herausgeberIdSekundaerItem) : sprintf('%s(%s)', gettype($herausgeberIdSekundaerItem), var_export($herausgeberIdSekundaerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idSekundaer
     * @return \StructType\Herausgeber
     */
    public function setIdSekundaer(array $idSekundaer = array())
    {
        // validation for constraint: array
        if ('' !== ($idSekundaerArrayErrorMessage = self::validateIdSekundaerForArrayConstraintsFromSetIdSekundaer($idSekundaer))) {
            throw new \InvalidArgumentException($idSekundaerArrayErrorMessage, __LINE__);
        }
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Add item to idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Herausgeber
     */
    public function addToIdSekundaer(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSekundaer[] = $item;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return string[]|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setBezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBezeichnungForArrayConstraintsFromSetBezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $herausgeberBezeichnungItem) {
            // validation for constraint: itemType
            if (!is_string($herausgeberBezeichnungItem)) {
                $invalidValues[] = is_object($herausgeberBezeichnungItem) ? get_class($herausgeberBezeichnungItem) : sprintf('%s(%s)', gettype($herausgeberBezeichnungItem), var_export($herausgeberBezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bezeichnung property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bezeichnung value
     * @throws \InvalidArgumentException
     * @param string[] $bezeichnung
     * @return \StructType\Herausgeber
     */
    public function setBezeichnung(array $bezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($bezeichnungArrayErrorMessage = self::validateBezeichnungForArrayConstraintsFromSetBezeichnung($bezeichnung))) {
            throw new \InvalidArgumentException($bezeichnungArrayErrorMessage, __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Add item to bezeichnung value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Herausgeber
     */
    public function addToBezeichnung($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The bezeichnung property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bezeichnung[] = $item;
        return $this;
    }
    /**
     * Get kurzbezeichnung value
     * @return string[]|null
     */
    public function getKurzbezeichnung()
    {
        return $this->kurzbezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setKurzbezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKurzbezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $herausgeberKurzbezeichnungItem) {
            // validation for constraint: itemType
            if (!is_string($herausgeberKurzbezeichnungItem)) {
                $invalidValues[] = is_object($herausgeberKurzbezeichnungItem) ? get_class($herausgeberKurzbezeichnungItem) : sprintf('%s(%s)', gettype($herausgeberKurzbezeichnungItem), var_export($herausgeberKurzbezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kurzbezeichnung property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param string[] $kurzbezeichnung
     * @return \StructType\Herausgeber
     */
    public function setKurzbezeichnung(array $kurzbezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($kurzbezeichnungArrayErrorMessage = self::validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung($kurzbezeichnung))) {
            throw new \InvalidArgumentException($kurzbezeichnungArrayErrorMessage, __LINE__);
        }
        $this->kurzbezeichnung = $kurzbezeichnung;
        return $this;
    }
    /**
     * Add item to kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Herausgeber
     */
    public function addToKurzbezeichnung($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The kurzbezeichnung property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kurzbezeichnung[] = $item;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $herausgeberBeschreibungItem) {
            // validation for constraint: itemType
            if (!$herausgeberBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($herausgeberBeschreibungItem) ? get_class($herausgeberBeschreibungItem) : sprintf('%s(%s)', gettype($herausgeberBeschreibungItem), var_export($herausgeberBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Herausgeber
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Herausgeber
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get standardZustaendigkeitsgebiet value
     * @return \StructType\Gebiet[]|null
     */
    public function getStandardZustaendigkeitsgebiet()
    {
        return $this->standardZustaendigkeitsgebiet;
    }
    /**
     * This method is responsible for validating the values passed to the setStandardZustaendigkeitsgebiet method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStandardZustaendigkeitsgebiet method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStandardZustaendigkeitsgebietForArrayConstraintsFromSetStandardZustaendigkeitsgebiet(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $herausgeberStandardZustaendigkeitsgebietItem) {
            // validation for constraint: itemType
            if (!$herausgeberStandardZustaendigkeitsgebietItem instanceof \StructType\Gebiet) {
                $invalidValues[] = is_object($herausgeberStandardZustaendigkeitsgebietItem) ? get_class($herausgeberStandardZustaendigkeitsgebietItem) : sprintf('%s(%s)', gettype($herausgeberStandardZustaendigkeitsgebietItem), var_export($herausgeberStandardZustaendigkeitsgebietItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The standardZustaendigkeitsgebiet property can only contain items of type \StructType\Gebiet, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set standardZustaendigkeitsgebiet value
     * @throws \InvalidArgumentException
     * @param \StructType\Gebiet[] $standardZustaendigkeitsgebiet
     * @return \StructType\Herausgeber
     */
    public function setStandardZustaendigkeitsgebiet(array $standardZustaendigkeitsgebiet = array())
    {
        // validation for constraint: array
        if ('' !== ($standardZustaendigkeitsgebietArrayErrorMessage = self::validateStandardZustaendigkeitsgebietForArrayConstraintsFromSetStandardZustaendigkeitsgebiet($standardZustaendigkeitsgebiet))) {
            throw new \InvalidArgumentException($standardZustaendigkeitsgebietArrayErrorMessage, __LINE__);
        }
        $this->standardZustaendigkeitsgebiet = $standardZustaendigkeitsgebiet;
        return $this;
    }
    /**
     * Add item to standardZustaendigkeitsgebiet value
     * @throws \InvalidArgumentException
     * @param \StructType\Gebiet $item
     * @return \StructType\Herausgeber
     */
    public function addToStandardZustaendigkeitsgebiet(\StructType\Gebiet $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Gebiet) {
            throw new \InvalidArgumentException(sprintf('The standardZustaendigkeitsgebiet property can only contain items of type \StructType\Gebiet, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->standardZustaendigkeitsgebiet[] = $item;
        return $this;
    }
}
