<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Gebietsklasse StructType
 * Meta information extracted from the WSDL
 * - documentation: Eine Gebietsklasse bestimmt einen Gebietstyp näher. Beispiele für Gebietsklassen sind "Verwaltungspolitsche Gebiete", "Kammerbezirke", "Straßen" oder "Gewässer".
 * @subpackage Structs
 */
class Gebietsklasse extends Kategorieklasse
{
    /**
     * The kurzbezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Kurzbezeichnung der Gebietsklasse.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $kurzbezeichnung;
    /**
     * Constructor method for Gebietsklasse
     * @uses Gebietsklasse::setKurzbezeichnung()
     * @param \StructType\String_Localized[] $kurzbezeichnung
     */
    public function __construct(array $kurzbezeichnung = array())
    {
        $this
            ->setKurzbezeichnung($kurzbezeichnung);
    }
    /**
     * Get kurzbezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getKurzbezeichnung()
    {
        return $this->kurzbezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setKurzbezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKurzbezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gebietsklasseKurzbezeichnungItem) {
            // validation for constraint: itemType
            if (!$gebietsklasseKurzbezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($gebietsklasseKurzbezeichnungItem) ? get_class($gebietsklasseKurzbezeichnungItem) : sprintf('%s(%s)', gettype($gebietsklasseKurzbezeichnungItem), var_export($gebietsklasseKurzbezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kurzbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $kurzbezeichnung
     * @return \StructType\Gebietsklasse
     */
    public function setKurzbezeichnung(array $kurzbezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($kurzbezeichnungArrayErrorMessage = self::validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung($kurzbezeichnung))) {
            throw new \InvalidArgumentException($kurzbezeichnungArrayErrorMessage, __LINE__);
        }
        $this->kurzbezeichnung = $kurzbezeichnung;
        return $this;
    }
    /**
     * Add item to kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Gebietsklasse
     */
    public function addToKurzbezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The kurzbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kurzbezeichnung[] = $item;
        return $this;
    }
}
