<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Gebiet StructType
 * Meta information extracted from the WSDL
 * - documentation: Gebiet repräsentiert eine räumlich (meist) zusammenhängende Fläche oder ein Areal. Für Zuständigkeitsfinder spielen insbesondere verwaltungspolitsche Gebiete eine Rolle. Zuständigkeiten werden für Gebiete definiert.
 * @subpackage Structs
 */
class Gebiet extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Primäre ID.
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * Meta information extracted from the WSDL
     * - documentation: Sekundäre IDs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idSekundaer;
    /**
     * The typ
     * Meta information extracted from the WSDL
     * - documentation: Zuordnung einen Gebietstyps zum Gebiet.
     * @var \StructType\Gebietstyp
     */
    public $typ;
    /**
     * The uebergeordnetesGebietID
     * Meta information extracted from the WSDL
     * - documentation: Die ID des übergeordneten Gebiets. Normalerweise sollte ein Gebiet nur ein übergeordnetes Gebiet besitzen. Wird ein Gebiet jedoch in zwei Klassen verwendet, z.B. innerhalb einer verwaltungspolitischen Struktur und Kammerbezirken,
     * können auch zwei oder mehrere Gebiete übergeordnet sein.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $uebergeordnetesGebietID;
    /**
     * The untergeordnetesGebietID
     * Meta information extracted from the WSDL
     * - documentation: Die IDs von untergeordneten Gebieten. Zum Beispiel die Referenz auf Gemeindeteile bei einer Gemeinde.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $untergeordnetesGebietID;
    /**
     * The verwaltungspolitischeKodierung
     * Meta information extracted from the WSDL
     * - documentation: Verwaltungspolitische Kodierung des Gebiets (z.B. AGS, Regionalschlüssel)
     * - minOccurs: 0
     * @var \StructType\VerwaltungspolitischeKodierung
     */
    public $verwaltungspolitischeKodierung;
    /**
     * The bezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Die Bezeichnung des Gebiets.
     * - maxOccurs: unbounded
     * @var \StructType\String_Localized[]
     */
    public $bezeichnung;
    /**
     * The kurzbezeichnung
     * Meta information extracted from the WSDL
     * - documentation: Eine kurze prägnante Bezeichnung des Gebiets.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $kurzbezeichnung;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Eine textuelle Beschreibung des Gebiets.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The herausgeber
     * Meta information extracted from the WSDL
     * - documentation: Optionale Angabe des Herausgebers der Daten.
     * - minOccurs: 0
     * @var \StructType\Herausgeber
     */
    public $herausgeber;
    /**
     * The versionsinformation
     * Meta information extracted from the WSDL
     * - documentation: Informationen zur Versionierung.
     * - minOccurs: 0
     * @var \StructType\Versionsinformation
     */
    public $versionsinformation;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for Gebiet
     * @uses Gebiet::setId()
     * @uses Gebiet::setIdSekundaer()
     * @uses Gebiet::setTyp()
     * @uses Gebiet::setUebergeordnetesGebietID()
     * @uses Gebiet::setUntergeordnetesGebietID()
     * @uses Gebiet::setVerwaltungspolitischeKodierung()
     * @uses Gebiet::setBezeichnung()
     * @uses Gebiet::setKurzbezeichnung()
     * @uses Gebiet::setBeschreibung()
     * @uses Gebiet::setHerausgeber()
     * @uses Gebiet::setVersionsinformation()
     * @uses Gebiet::setGueltigkeit()
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator[] $idSekundaer
     * @param \StructType\Gebietstyp $typ
     * @param \StructType\Identifikator[] $uebergeordnetesGebietID
     * @param \StructType\Identifikator[] $untergeordnetesGebietID
     * @param \StructType\VerwaltungspolitischeKodierung $verwaltungspolitischeKodierung
     * @param \StructType\String_Localized[] $bezeichnung
     * @param \StructType\String_Localized[] $kurzbezeichnung
     * @param \StructType\String_Localized[] $beschreibung
     * @param \StructType\Herausgeber $herausgeber
     * @param \StructType\Versionsinformation $versionsinformation
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(\StructType\Identifikator $id = null, array $idSekundaer = array(), \StructType\Gebietstyp $typ = null, array $uebergeordnetesGebietID = array(), array $untergeordnetesGebietID = array(), \StructType\VerwaltungspolitischeKodierung $verwaltungspolitischeKodierung = null, array $bezeichnung = array(), array $kurzbezeichnung = array(), array $beschreibung = array(), \StructType\Herausgeber $herausgeber = null, \StructType\Versionsinformation $versionsinformation = null, array $gueltigkeit = array())
    {
        $this
            ->setId($id)
            ->setIdSekundaer($idSekundaer)
            ->setTyp($typ)
            ->setUebergeordnetesGebietID($uebergeordnetesGebietID)
            ->setUntergeordnetesGebietID($untergeordnetesGebietID)
            ->setVerwaltungspolitischeKodierung($verwaltungspolitischeKodierung)
            ->setBezeichnung($bezeichnung)
            ->setKurzbezeichnung($kurzbezeichnung)
            ->setBeschreibung($beschreibung)
            ->setHerausgeber($herausgeber)
            ->setVersionsinformation($versionsinformation)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Gebiet
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSekundaer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSekundaer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSekundaerForArrayConstraintsFromSetIdSekundaer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gebietIdSekundaerItem) {
            // validation for constraint: itemType
            if (!$gebietIdSekundaerItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($gebietIdSekundaerItem) ? get_class($gebietIdSekundaerItem) : sprintf('%s(%s)', gettype($gebietIdSekundaerItem), var_export($gebietIdSekundaerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idSekundaer
     * @return \StructType\Gebiet
     */
    public function setIdSekundaer(array $idSekundaer = array())
    {
        // validation for constraint: array
        if ('' !== ($idSekundaerArrayErrorMessage = self::validateIdSekundaerForArrayConstraintsFromSetIdSekundaer($idSekundaer))) {
            throw new \InvalidArgumentException($idSekundaerArrayErrorMessage, __LINE__);
        }
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Add item to idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Gebiet
     */
    public function addToIdSekundaer(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSekundaer[] = $item;
        return $this;
    }
    /**
     * Get typ value
     * @return \StructType\Gebietstyp|null
     */
    public function getTyp()
    {
        return $this->typ;
    }
    /**
     * Set typ value
     * @param \StructType\Gebietstyp $typ
     * @return \StructType\Gebiet
     */
    public function setTyp(\StructType\Gebietstyp $typ = null)
    {
        $this->typ = $typ;
        return $this;
    }
    /**
     * Get uebergeordnetesGebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getUebergeordnetesGebietID()
    {
        return $this->uebergeordnetesGebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setUebergeordnetesGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUebergeordnetesGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUebergeordnetesGebietIDForArrayConstraintsFromSetUebergeordnetesGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gebietUebergeordnetesGebietIDItem) {
            // validation for constraint: itemType
            if (!$gebietUebergeordnetesGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($gebietUebergeordnetesGebietIDItem) ? get_class($gebietUebergeordnetesGebietIDItem) : sprintf('%s(%s)', gettype($gebietUebergeordnetesGebietIDItem), var_export($gebietUebergeordnetesGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The uebergeordnetesGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set uebergeordnetesGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $uebergeordnetesGebietID
     * @return \StructType\Gebiet
     */
    public function setUebergeordnetesGebietID(array $uebergeordnetesGebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($uebergeordnetesGebietIDArrayErrorMessage = self::validateUebergeordnetesGebietIDForArrayConstraintsFromSetUebergeordnetesGebietID($uebergeordnetesGebietID))) {
            throw new \InvalidArgumentException($uebergeordnetesGebietIDArrayErrorMessage, __LINE__);
        }
        $this->uebergeordnetesGebietID = $uebergeordnetesGebietID;
        return $this;
    }
    /**
     * Add item to uebergeordnetesGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Gebiet
     */
    public function addToUebergeordnetesGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The uebergeordnetesGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->uebergeordnetesGebietID[] = $item;
        return $this;
    }
    /**
     * Get untergeordnetesGebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getUntergeordnetesGebietID()
    {
        return $this->untergeordnetesGebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setUntergeordnetesGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUntergeordnetesGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUntergeordnetesGebietIDForArrayConstraintsFromSetUntergeordnetesGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gebietUntergeordnetesGebietIDItem) {
            // validation for constraint: itemType
            if (!$gebietUntergeordnetesGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($gebietUntergeordnetesGebietIDItem) ? get_class($gebietUntergeordnetesGebietIDItem) : sprintf('%s(%s)', gettype($gebietUntergeordnetesGebietIDItem), var_export($gebietUntergeordnetesGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The untergeordnetesGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set untergeordnetesGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $untergeordnetesGebietID
     * @return \StructType\Gebiet
     */
    public function setUntergeordnetesGebietID(array $untergeordnetesGebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($untergeordnetesGebietIDArrayErrorMessage = self::validateUntergeordnetesGebietIDForArrayConstraintsFromSetUntergeordnetesGebietID($untergeordnetesGebietID))) {
            throw new \InvalidArgumentException($untergeordnetesGebietIDArrayErrorMessage, __LINE__);
        }
        $this->untergeordnetesGebietID = $untergeordnetesGebietID;
        return $this;
    }
    /**
     * Add item to untergeordnetesGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Gebiet
     */
    public function addToUntergeordnetesGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The untergeordnetesGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->untergeordnetesGebietID[] = $item;
        return $this;
    }
    /**
     * Get verwaltungspolitischeKodierung value
     * @return \StructType\VerwaltungspolitischeKodierung|null
     */
    public function getVerwaltungspolitischeKodierung()
    {
        return $this->verwaltungspolitischeKodierung;
    }
    /**
     * Set verwaltungspolitischeKodierung value
     * @param \StructType\VerwaltungspolitischeKodierung $verwaltungspolitischeKodierung
     * @return \StructType\Gebiet
     */
    public function setVerwaltungspolitischeKodierung(\StructType\VerwaltungspolitischeKodierung $verwaltungspolitischeKodierung = null)
    {
        $this->verwaltungspolitischeKodierung = $verwaltungspolitischeKodierung;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setBezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBezeichnungForArrayConstraintsFromSetBezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gebietBezeichnungItem) {
            // validation for constraint: itemType
            if (!$gebietBezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($gebietBezeichnungItem) ? get_class($gebietBezeichnungItem) : sprintf('%s(%s)', gettype($gebietBezeichnungItem), var_export($gebietBezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $bezeichnung
     * @return \StructType\Gebiet
     */
    public function setBezeichnung(array $bezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($bezeichnungArrayErrorMessage = self::validateBezeichnungForArrayConstraintsFromSetBezeichnung($bezeichnung))) {
            throw new \InvalidArgumentException($bezeichnungArrayErrorMessage, __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Add item to bezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Gebiet
     */
    public function addToBezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The bezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bezeichnung[] = $item;
        return $this;
    }
    /**
     * Get kurzbezeichnung value
     * @return \StructType\String_Localized[]|null
     */
    public function getKurzbezeichnung()
    {
        return $this->kurzbezeichnung;
    }
    /**
     * This method is responsible for validating the values passed to the setKurzbezeichnung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKurzbezeichnung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gebietKurzbezeichnungItem) {
            // validation for constraint: itemType
            if (!$gebietKurzbezeichnungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($gebietKurzbezeichnungItem) ? get_class($gebietKurzbezeichnungItem) : sprintf('%s(%s)', gettype($gebietKurzbezeichnungItem), var_export($gebietKurzbezeichnungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kurzbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $kurzbezeichnung
     * @return \StructType\Gebiet
     */
    public function setKurzbezeichnung(array $kurzbezeichnung = array())
    {
        // validation for constraint: array
        if ('' !== ($kurzbezeichnungArrayErrorMessage = self::validateKurzbezeichnungForArrayConstraintsFromSetKurzbezeichnung($kurzbezeichnung))) {
            throw new \InvalidArgumentException($kurzbezeichnungArrayErrorMessage, __LINE__);
        }
        $this->kurzbezeichnung = $kurzbezeichnung;
        return $this;
    }
    /**
     * Add item to kurzbezeichnung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Gebiet
     */
    public function addToKurzbezeichnung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The kurzbezeichnung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kurzbezeichnung[] = $item;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gebietBeschreibungItem) {
            // validation for constraint: itemType
            if (!$gebietBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($gebietBeschreibungItem) ? get_class($gebietBeschreibungItem) : sprintf('%s(%s)', gettype($gebietBeschreibungItem), var_export($gebietBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Gebiet
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Gebiet
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get herausgeber value
     * @return \StructType\Herausgeber|null
     */
    public function getHerausgeber()
    {
        return $this->herausgeber;
    }
    /**
     * Set herausgeber value
     * @param \StructType\Herausgeber $herausgeber
     * @return \StructType\Gebiet
     */
    public function setHerausgeber(\StructType\Herausgeber $herausgeber = null)
    {
        $this->herausgeber = $herausgeber;
        return $this;
    }
    /**
     * Get versionsinformation value
     * @return \StructType\Versionsinformation|null
     */
    public function getVersionsinformation()
    {
        return $this->versionsinformation;
    }
    /**
     * Set versionsinformation value
     * @param \StructType\Versionsinformation $versionsinformation
     * @return \StructType\Gebiet
     */
    public function setVersionsinformation(\StructType\Versionsinformation $versionsinformation = null)
    {
        $this->versionsinformation = $versionsinformation;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $gebietGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$gebietGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($gebietGueltigkeitItem) ? get_class($gebietGueltigkeitItem) : sprintf('%s(%s)', gettype($gebietGueltigkeitItem), var_export($gebietGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Gebiet
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Gebiet
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
